/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.validation.field;

import java.util.function.Function;
import java.util.function.Predicate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hawaiiframework.validation.ValidationResult;

public class FieldRejection<T> {
    public static final String REQUIRED = "required";
    public static final String INVALID = "invalid";
    private final ValidationResult validationResult;
    private final String field;
    private final T actual;
    private boolean mustEvaluate = true;

    public FieldRejection(ValidationResult validationResult, String field, T actual) {
        this.validationResult = validationResult;
        this.field = field;
        this.actual = actual;
    }

    private FieldRejection<T> evaluate(Matcher<?> matcher, String code) {
        if (this.mustEvaluate && matcher.matches(this.actual)) {
            this.mustEvaluate = false;
            this.validationResult.rejectValue(this.field, code);
        }
        return this;
    }

    public FieldRejection<T> or() {
        return this;
    }

    public FieldRejection<T> or(Matcher<T> matcher) {
        return this.when(matcher);
    }

    public FieldRejection<T> or(Matcher<T> matcher, String code) {
        return this.when(matcher, code);
    }

    public FieldRejection<T> or(Predicate<T> predicate) {
        return this.when(predicate);
    }

    public FieldRejection<T> or(Predicate<T> predicate, String code) {
        return this.when(predicate, code);
    }

    public <R> FieldRejection<T> or(Function<T, R> function, Matcher<R> matcher) {
        return this.when(function, matcher, INVALID);
    }

    public <R> FieldRejection<T> or(Function<T, R> function, Matcher<R> matcher, String code) {
        return this.when(function, matcher, code);
    }

    public FieldRejection<T> whenNull() {
        return this.whenNull(REQUIRED);
    }

    public FieldRejection<T> whenNull(String code) {
        return this.evaluate(Matchers.nullValue(), code);
    }

    public FieldRejection<T> when(Matcher<T> matcher) {
        return this.when(matcher, INVALID);
    }

    public FieldRejection<T> when(Matcher<T> matcher, String code) {
        return this.evaluate(matcher, code);
    }

    public FieldRejection<T> when(Predicate<T> predicate) {
        return this.when(predicate, INVALID);
    }

    public <R> FieldRejection<T> when(Function<T, R> function, Matcher<R> matcher) {
        return this.when(function, matcher, INVALID);
    }

    public <R> FieldRejection<T> when(Function<T, R> function, Matcher<R> matcher, String code) {
        return this.when((T v) -> matcher.matches(function.apply(v)), code);
    }

    public FieldRejection<T> when(Predicate<T> predicate, String code) {
        if (this.mustEvaluate && predicate.test(this.actual)) {
            this.mustEvaluate = false;
            this.validationResult.rejectValue(this.field, code);
        }
        return this;
    }

    public FieldRejection<T> orWhen(Matcher<T> matcher) {
        return this.when(matcher);
    }

    public FieldRejection<T> orWhen(Matcher<T> matcher, String code) {
        return this.when(matcher, code);
    }

    public FieldRejection<T> orWhen(Predicate<T> predicate) {
        return this.when(predicate);
    }

    public FieldRejection<T> orWhen(Predicate<T> predicate, String code) {
        return this.when(predicate, code);
    }

    public <R> FieldRejection<T> orWhen(Function<T, R> function, Matcher<R> matcher) {
        return this.when(function, matcher, INVALID);
    }

    public <R> FieldRejection<T> orWhen(Function<T, R> function, Matcher<R> matcher, String code) {
        return this.when(function, matcher, code);
    }
}

