/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.exception;

import org.hawaiiframework.exception.ApiException;
import org.hawaiiframework.exception.HawaiiException;
import org.hawaiiframework.validation.ValidationException;
import org.hawaiiframework.web.exception.ExceptionResponseFactory;
import org.hawaiiframework.web.resource.ApiErrorResponseResource;
import org.hawaiiframework.web.resource.ErrorResponseResource;
import org.hawaiiframework.web.resource.MethodArgumentNotValidResponseResource;
import org.hawaiiframework.web.resource.ValidationErrorResponseResource;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.MethodArgumentNotValidException;

@Component
public class DefaultExceptionResponseFactory
implements ExceptionResponseFactory {
    @Override
    public ErrorResponseResource create(Throwable throwable) {
        ErrorResponseResource result = null;
        if (throwable != null && (result = this.getErrorResponseResource(throwable)) == null) {
            Throwable cause = this.getCausingHawaiiException(throwable);
            result = this.getErrorResponseResource(cause);
        }
        if (result == null) {
            result = new ErrorResponseResource(throwable);
        }
        return result;
    }

    private ErrorResponseResource getErrorResponseResource(Throwable throwable) {
        ErrorResponseResource result;
        if (throwable instanceof ApiException) {
            ApiException apiException = (ApiException)throwable;
            result = new ApiErrorResponseResource(apiException);
        } else if (throwable instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException methodArgumentNotValidException = (MethodArgumentNotValidException)throwable;
            result = new MethodArgumentNotValidResponseResource(methodArgumentNotValidException);
        } else if (throwable instanceof ValidationException) {
            ValidationException validationException = (ValidationException)throwable;
            result = new ValidationErrorResponseResource(validationException);
        } else {
            result = null;
        }
        return result;
    }

    private Throwable getCausingHawaiiException(Throwable throwable) {
        Throwable cause = this.getCause(throwable.getCause());
        if (cause == null) {
            cause = throwable;
        }
        return cause;
    }

    private Throwable getCause(Throwable throwable) {
        Throwable cause = throwable == null ? null : (throwable instanceof HawaiiException ? throwable : this.getCause(throwable.getCause()));
        return cause;
    }
}

