/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.exception;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hawaiiframework.web.exception.ErrorResponseEnricher;
import org.hawaiiframework.web.exception.ExceptionResponseFactory;
import org.hawaiiframework.web.resource.ErrorResponseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.WebRequest;

public class ErrorResponseEntityBuilder {
    private final ExceptionResponseFactory exceptionResponseFactory;
    private final Set<ErrorResponseEnricher> errorResponseEnrichers = new HashSet<ErrorResponseEnricher>();

    public ErrorResponseEntityBuilder(ExceptionResponseFactory exceptionResponseFactory, List<ErrorResponseEnricher> errorResponseEnrichers) {
        this.exceptionResponseFactory = Objects.requireNonNull(exceptionResponseFactory, "'exceptionResponseFactory' must not be null");
        if (errorResponseEnrichers != null) {
            this.errorResponseEnrichers.addAll(errorResponseEnrichers);
        }
    }

    public ErrorResponseResource buildErrorResponseBody(Throwable throwable, HttpStatus status, WebRequest request) {
        ErrorResponseResource resource = this.exceptionResponseFactory.create(throwable);
        this.getResponseEnrichers().forEach(enricher -> enricher.enrich(resource, request, status));
        return resource;
    }

    public void addResponseEnricher(ErrorResponseEnricher errorResponseEnricher) {
        this.errorResponseEnrichers.add(errorResponseEnricher);
    }

    public void removeResponseEnricher(ErrorResponseEnricher errorResponseEnricher) {
        this.errorResponseEnrichers.remove(errorResponseEnricher);
    }

    public Collection<ErrorResponseEnricher> getResponseEnrichers() {
        return new HashSet<ErrorResponseEnricher>(this.errorResponseEnrichers);
    }
}

