/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.exception;

import org.hawaiiframework.exception.ApiException;
import org.hawaiiframework.validation.ValidationException;
import org.hawaiiframework.web.exception.ErrorResponseEntityBuilder;
import org.hawaiiframework.web.exception.HttpException;
import org.hawaiiframework.web.resource.ErrorResponseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Order
@ControllerAdvice
public class HawaiiResponseEntityExceptionHandler
extends ResponseEntityExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ErrorResponseEntityBuilder errorResponseEntityBuilder;

    public HawaiiResponseEntityExceptionHandler(ErrorResponseEntityBuilder errorResponseEntityBuilder) {
        this.errorResponseEntityBuilder = errorResponseEntityBuilder;
    }

    @ExceptionHandler(value={HttpException.class})
    @ResponseBody
    public ResponseEntity<Object> handleHttpException(HttpException e, WebRequest request) {
        HttpStatus status = e.getHttpStatus();
        return this.handleExceptionInternal(e, this.buildErrorResponseBody(e, status, request), HttpHeaders.EMPTY, (HttpStatusCode)status, request);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(@NonNull MethodArgumentNotValidException ex, @NonNull HttpHeaders headers, @NonNull HttpStatusCode status, @NonNull WebRequest request) {
        return this.handleExceptionInternal((Exception)ex, this.buildErrorResponseBody((Throwable)ex, HttpStatus.valueOf((int)status.value()), request), HttpHeaders.EMPTY, status, request);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseBody
    public ResponseEntity<Object> handleValidationException(ValidationException e, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return this.handleExceptionInternal(e, this.buildErrorResponseBody(e, status, request), HttpHeaders.EMPTY, (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={ApiException.class})
    @ResponseBody
    public ResponseEntity<Object> handleApiException(ApiException e, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        return this.handleExceptionInternal(e, this.buildErrorResponseBody(e, status, request), HttpHeaders.EMPTY, (HttpStatusCode)status, request);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public ResponseEntity<Object> handleThrowable(Throwable t, WebRequest request) {
        this.logger.error("Unhandled exception", t);
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        return ResponseEntity.status((HttpStatusCode)status).body((Object)this.buildErrorResponseBody(t, status, request));
    }

    private ErrorResponseResource buildErrorResponseBody(Throwable throwable, HttpStatus status, WebRequest request) {
        return this.errorResponseEntityBuilder.buildErrorResponseBody(throwable, status, request);
    }
}

