/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.exception;

import java.util.List;
import java.util.Objects;
import org.hawaiiframework.converter.ModelConverter;
import org.hawaiiframework.web.exception.ErrorResponseEnricher;
import org.hawaiiframework.web.resource.ErrorResponseResource;
import org.hawaiiframework.web.resource.MethodArgumentNotValidResponseResource;
import org.hawaiiframework.web.resource.ValidationErrorResource;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.WebRequest;

public class MethodArgumentNotValidResponseEnricher
implements ErrorResponseEnricher {
    private final ModelConverter<ObjectError, ValidationErrorResource> objectErrorResourceAssembler;

    public MethodArgumentNotValidResponseEnricher(ModelConverter<ObjectError, ValidationErrorResource> objectErrorResourceAssembler) {
        this.objectErrorResourceAssembler = Objects.requireNonNull(objectErrorResourceAssembler, "'objectErrorResourceAssembler' must not be null");
    }

    @Override
    public void doEnrich(ErrorResponseResource errorResponseResource, Throwable throwable, WebRequest request, HttpStatus httpStatus) {
        if (throwable instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException validationException = (MethodArgumentNotValidException)throwable;
            if (errorResponseResource instanceof MethodArgumentNotValidResponseResource) {
                MethodArgumentNotValidResponseResource resource = (MethodArgumentNotValidResponseResource)errorResponseResource;
                List<ObjectError> errors = this.getErrors(validationException);
                if (!errors.isEmpty()) {
                    resource.setErrors(this.objectErrorResourceAssembler.convert(errors));
                }
            }
        }
    }

    private List<ObjectError> getErrors(MethodArgumentNotValidException methodArgumentNotValidException) {
        return this.getErrors(methodArgumentNotValidException.getBindingResult());
    }

    private List<ObjectError> getErrors(BindingResult validationResult) {
        return validationResult.getAllErrors();
    }
}

