/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.exception;

import java.util.List;
import java.util.Objects;
import org.hawaiiframework.converter.ModelConverter;
import org.hawaiiframework.validation.ValidationError;
import org.hawaiiframework.validation.ValidationException;
import org.hawaiiframework.validation.ValidationResult;
import org.hawaiiframework.web.exception.ErrorResponseEnricher;
import org.hawaiiframework.web.resource.ErrorResponseResource;
import org.hawaiiframework.web.resource.ValidationErrorResource;
import org.hawaiiframework.web.resource.ValidationErrorResponseResource;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.WebRequest;

public class ValidationErrorResponseEnricher
implements ErrorResponseEnricher {
    private final ModelConverter<ValidationError, ValidationErrorResource> validationErrorResourceAssembler;

    public ValidationErrorResponseEnricher(ModelConverter<ValidationError, ValidationErrorResource> validationErrorResourceAssembler) {
        this.validationErrorResourceAssembler = Objects.requireNonNull(validationErrorResourceAssembler, "'validationErrorResourceAssembler' must not be null");
    }

    @Override
    public void doEnrich(ErrorResponseResource errorResponseResource, Throwable throwable, WebRequest request, HttpStatus httpStatus) {
        if (throwable instanceof ValidationException) {
            ValidationException validationException = (ValidationException)throwable;
            if (errorResponseResource instanceof ValidationErrorResponseResource) {
                ValidationErrorResponseResource resource = (ValidationErrorResponseResource)errorResponseResource;
                List<ValidationError> errors = this.getErrors(validationException);
                if (errors != null && !errors.isEmpty()) {
                    resource.setErrors(this.validationErrorResourceAssembler.convert(errors));
                }
            }
        }
    }

    private List<ValidationError> getErrors(ValidationException validationException) {
        return this.getErrors(validationException.getValidationResult());
    }

    private List<ValidationError> getErrors(ValidationResult validationResult) {
        return validationResult.getErrors();
    }
}

