/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.web.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.Objects;
import org.hawaiiframework.converter.AbstractModelConverter;
import org.hawaiiframework.web.resource.ValidationErrorResource;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ObjectErrorResourceAssembler
extends AbstractModelConverter<ObjectError, ValidationErrorResource> {
    private final ObjectMapper objectMapper;

    public ObjectErrorResourceAssembler(ObjectMapper objectMapper) {
        super(ValidationErrorResource.class);
        this.objectMapper = Objects.requireNonNull(objectMapper, "'objectMapper' must not be null");
    }

    @Override
    public void convert(ObjectError objectError, ValidationErrorResource resource) {
        String field;
        Objects.requireNonNull(objectError, "'objectError' must not be null");
        if (objectError instanceof FieldError) {
            FieldError fieldError = (FieldError)objectError;
            field = this.convertProperty(fieldError.getField());
        } else {
            field = objectError.getObjectName();
        }
        String code = this.convertProperty(objectError.getCode());
        resource.setField(field);
        resource.setCode(code);
    }

    protected String convertProperty(String propertyName) {
        PropertyNamingStrategy propertyNamingStrategy;
        String name = this.objectMapper == null || propertyName == null || propertyName.length() == 0 ? propertyName : ((propertyNamingStrategy = this.objectMapper.getSerializationConfig().getPropertyNamingStrategy()) == null ? propertyName : propertyNamingStrategy.nameForField(null, null, propertyName));
        return name;
    }
}

