/*
 * Decompiled with CFR 0.152.
 */
package org.hawksoft.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hawksoft.json.ISchemaProvider;
import org.hawksoft.json.JSONSchemaValidator;
import org.hawksoft.json.JSONValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JSONSchemaRepository
implements ISchemaProvider {
    private static final Logger _log = LoggerFactory.getLogger(JSONSchemaRepository.class);
    private static final int INDENT = 4;
    private Map<String, JSONObject> _schemaMap = new HashMap<String, JSONObject>();
    private Map<String, String> _examples = null;

    public Map<String, String> getAllSchemas() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, JSONObject> entry : this._schemaMap.entrySet()) {
            try {
                result.put(entry.getKey(), entry.getValue().toString(4));
            }
            catch (JSONException e) {
                _log.error("error building json for {}", (Object)entry.getKey());
            }
        }
        return result;
    }

    public Map<String, String> getAllExamples() {
        if (null == this._examples) {
            this._examples = new HashMap<String, String>();
            for (Map.Entry<String, JSONObject> entry : this._schemaMap.entrySet()) {
                try {
                    this._examples.put(entry.getKey(), this.getExample(entry.getValue()).toString(4));
                }
                catch (JSONException e) {
                    _log.error("error building json example for {}", (Object)entry.getKey());
                }
            }
        }
        return this._examples;
    }

    public JSONSchemaRepository(String repoPath) throws JSONValidationException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(repoPath + "/*.jsd")) {
                JSONObject schema = JSONSchemaValidator.loadAndValidateSchema(resource.getInputStream());
                this._schemaMap.put(this.getSchemaIdentifier(schema.getJSONObject("document")), schema);
            }
        }
        catch (IOException | JSONException e) {
            throw new JSONValidationException((Exception)e);
        }
    }

    private String getSchemaIdentifier(JSONObject json) {
        return this.getSchemaIdentifier(json.optString("namespace"), json.optString("id"), json.optString("version"));
    }

    private String getSchemaIdentifier(String namespace, String id, String version) {
        return String.format("application/%s-%s-%s+json", namespace, id, version);
    }

    @Override
    public JSONObject getSchema(String namespace, String schemaId, String version) {
        return this._schemaMap.get(this.getSchemaIdentifier(namespace, schemaId, version));
    }

    public JSONObject getExample(JSONObject schema) {
        JSONObject example = null;
        try {
            example = new JSONObject(schema.toString());
            JSONObject doc = example.getJSONObject("document");
            doc.put("type", (Object)"instance");
            doc.remove("model");
            this.extractExample(example, "document");
        }
        catch (JSONException e) {
            _log.error("", (Throwable)e);
        }
        return example;
    }

    public JSONObject getExample(String namespace, String schemaId, String version) {
        return this.getExample(this.getSchema(namespace, schemaId, version));
    }

    private JSONObject extractExample(JSONObject json, String ignores) throws JSONException {
        JSONArray array = json.names();
        for (int i = 0; i < array.length(); ++i) {
            String attributeName = array.getString(i);
            if (ignores.equalsIgnoreCase(attributeName)) continue;
            Object attribute = json.get(attributeName);
            if (attributeName.contains("?")) {
                json.remove(attributeName);
                attributeName = attributeName.substring(0, attributeName.indexOf(63));
                json.put(attributeName, attribute);
            }
            if (attribute instanceof JSONObject) {
                this.extractExample((JSONObject)attribute, "");
                continue;
            }
            if (attribute instanceof JSONArray) {
                this.extractExample((JSONArray)attribute);
                continue;
            }
            json.put(attributeName, this.extractExample((String)attribute));
        }
        return json;
    }

    private Map<String, String> getAttributes(String attributes) {
        String[] parts;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : parts = attributes.split(";")) {
            String[] keyValue = part.split("=");
            result.put(keyValue[0], keyValue[1]);
        }
        return result;
    }

    private Object extractExample(String attributes) {
        Map<String, String> map = this.getAttributes(attributes);
        return map.get("example");
    }

    private JSONArray extractExample(JSONArray array) throws JSONException {
        Object value = array.get(0);
        array.remove(value);
        if (value instanceof JSONObject) {
            array.put((Object)this.extractExample((JSONObject)value, ""));
        } else if (value instanceof JSONArray) {
            array.put((Object)this.extractExample((JSONArray)value));
        } else {
            array.put(this.extractExample((String)value));
        }
        return array;
    }
}

