/*
 * Decompiled with CFR 0.152.
 */
package org.hawksoft.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hawksoft.json.ISchemaProvider;
import org.hawksoft.json.JSONValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSONSchemaValidator {
    private static final Logger _log = LoggerFactory.getLogger(JSONSchemaValidator.class);
    private static final Pattern _uuidPattern = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}");
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final Map<String, DateFormat> _dateFormats = new HashMap<String, DateFormat>();
    private static final Set<String> _modelSet;

    private JSONSchemaValidator() {
    }

    public static void validateDocument(JSONObject json, ISchemaProvider schemaProvider) throws JSONValidationException {
        JSONSchemaValidator validator = new JSONSchemaValidator();
        validator.validateDocTypeDocument(json, schemaProvider);
    }

    public static void validateDocument(JSONObject json, final JSONObject schema) throws JSONValidationException {
        JSONSchemaValidator.validateDocument(json, new ISchemaProvider(){

            @Override
            public JSONObject getSchema(String namespace, String schemaId, String version) {
                return schema;
            }
        });
    }

    public static void validateDocument(String json, String schema) throws JSONValidationException {
        try {
            JSONSchemaValidator.validateDocument(new JSONObject(json), new JSONObject(schema));
        }
        catch (JSONException e) {
            throw new JSONValidationException((Exception)((Object)e));
        }
    }

    public static void validateDocument(String json, ISchemaProvider schemaProvider) throws JSONValidationException {
        try {
            JSONSchemaValidator.validateDocument(new JSONObject(json), schemaProvider);
        }
        catch (JSONException e) {
            throw new JSONValidationException((Exception)((Object)e));
        }
    }

    public static void validateDocument(InputStream json, ISchemaProvider schemaProvider) throws JSONValidationException {
        JSONSchemaValidator.validateDocument(JSONSchemaValidator.loadDocument(json), schemaProvider);
    }

    public static void validateSchema(JSONObject schema) throws JSONValidationException {
        JSONSchemaValidator validator = new JSONSchemaValidator();
        validator.validateDocTypeSchema(schema);
    }

    public static JSONObject loadAndValidateSchema(InputStream is) throws JSONValidationException {
        JSONObject result = null;
        try {
            result = new JSONObject(JSONSchemaValidator.loadDocument(is));
            JSONSchemaValidator.validateSchema(result);
        }
        catch (JSONException e) {
            throw new JSONValidationException((Exception)((Object)e));
        }
        return result;
    }

    private static String loadDocument(InputStream is) throws JSONValidationException {
        String result = null;
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while (null != (line = reader.readLine())) {
                sb.append(line);
            }
            reader.close();
            result = sb.toString();
        }
        catch (IOException e) {
            throw new JSONValidationException(e);
        }
        return result;
    }

    private JSONObject assertChildObjectExists(JSONObject json, String childName) throws JSONValidationException {
        JSONObject child = null;
        try {
            child = json.getJSONObject(childName);
        }
        catch (JSONException e) {
            throw new JSONValidationException(String.format("required child object '%s' is missing", childName), (Exception)((Object)e));
        }
        return child;
    }

    private void assertModelSupported(String model) throws JSONValidationException {
        if (!_modelSet.contains(model)) {
            throw new JSONValidationException(String.format("model '%s' not supported", model));
        }
    }

    private JSONObject assertStringEquals(JSONObject json, String key, String expectedValue) throws JSONValidationException {
        String value = this.assertStringExists(json, key);
        if (!value.equalsIgnoreCase(expectedValue)) {
            throw new JSONValidationException(String.format("value '%s' for property '%s' does not match expected value '%s'", value, key, expectedValue));
        }
        return json;
    }

    private String assertStringExists(JSONObject json, String key) throws JSONValidationException {
        String result = null;
        try {
            result = json.getString(key);
            if (null == result || result.trim().isEmpty()) {
                throw new JSONValidationException(String.format("required property '%s' is blank", key));
            }
        }
        catch (JSONException e) {
            throw new JSONValidationException(String.format("error accessing string property '%s'", key), (Exception)((Object)e));
        }
        return result;
    }

    private String getRealAttributeName(String attribute) {
        return attribute.split("[?]")[0];
    }

    private Map<String, String> getValidations(String schema) throws JSONValidationException {
        String[] attributes = schema.split("[;]");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attribute : attributes) {
            String[] keyValue = attribute.split("[=]");
            if (keyValue.length != 2) {
                throw new JSONValidationException(String.format("invalid schema attribute entry '%s'", attribute));
            }
            result.put(keyValue[0], keyValue[1]);
        }
        return result;
    }

    private boolean isOptional(String attribute) {
        return attribute.contains("?");
    }

    private void validateObject(JSONObject doc, JSONObject schema, boolean skipDoc) throws JSONValidationException {
        JSONArray schemaChildren = schema.names();
        HashSet<String> schemaAttributes = new HashSet<String>();
        for (int i = 0; i < schemaChildren.length(); ++i) {
            try {
                String childAttribute = schemaChildren.getString(i);
                schemaAttributes.add(childAttribute);
                if (skipDoc && childAttribute.equalsIgnoreCase("document")) continue;
                this.validateAttribute(doc, schema, childAttribute);
                continue;
            }
            catch (JSONException e) {
                throw new JSONValidationException("error processing object attributes", (Exception)((Object)e));
            }
        }
        StringBuilder sb = new StringBuilder();
        JSONArray docChildren = doc.names();
        if (docChildren.length() > schemaChildren.length()) {
            for (int i = 0; i < docChildren.length(); ++i) {
                try {
                    String docAttribute = docChildren.getString(i);
                    if (schemaAttributes.contains(docAttribute)) continue;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(docAttribute);
                    continue;
                }
                catch (JSONException e) {
                    throw new JSONValidationException("error processing document attributes", (Exception)((Object)e));
                }
            }
        }
        if (sb.length() > 0) {
            throw new JSONValidationException(String.format("the document contains the following extraneous attribute(s): %s", sb.toString()));
        }
    }

    private void validateArray(JSONArray docArray, JSONArray schemaArray) throws JSONValidationException {
        if (schemaArray.length() != 1) {
            throw new JSONValidationException("array element schema must contain one and only one entry");
        }
        Object oSchema = null;
        try {
            oSchema = schemaArray.get(0);
        }
        catch (JSONException e) {
            throw new JSONValidationException("invalid schema array definition", (Exception)((Object)e));
        }
        if (oSchema instanceof JSONObject) {
            this.validateArrayObjects(docArray, (JSONObject)oSchema);
        } else if (oSchema instanceof JSONArray) {
            this.validateNestedArray(docArray, (JSONArray)oSchema);
        } else {
            this.validateArrayValues(docArray, (String)oSchema);
        }
    }

    private void validateArrayValues(JSONArray docArray, String schema) throws JSONValidationException {
        for (int i = 0; i < docArray.length(); ++i) {
            try {
                this.validateValue("", docArray.get(i), schema);
                continue;
            }
            catch (JSONException e) {
                throw new JSONValidationException("error processing json array", (Exception)((Object)e));
            }
        }
    }

    private void validateNestedArray(JSONArray docArray, JSONArray oSchema) throws JSONValidationException {
        for (int i = 0; i < docArray.length(); ++i) {
            try {
                this.validateArray(docArray.getJSONArray(i), oSchema);
                continue;
            }
            catch (JSONException e) {
                throw new JSONValidationException("invalid nested array in array", (Exception)((Object)e));
            }
        }
    }

    private void validateArrayObjects(JSONArray docArray, JSONObject oSchema) throws JSONValidationException {
        for (int i = 0; i < docArray.length(); ++i) {
            try {
                this.validateObject(docArray.getJSONObject(i), oSchema, false);
                continue;
            }
            catch (JSONException e) {
                throw new JSONValidationException("invalid object in array", (Exception)((Object)e));
            }
        }
    }

    private void validateObject(JSONObject doc, String docAttribute, JSONObject schemaChild, boolean optional) throws JSONValidationException {
        block2: {
            JSONObject docChild = null;
            try {
                docChild = doc.getJSONObject(docAttribute);
                this.validateObject(docChild, schemaChild, false);
            }
            catch (JSONException e) {
                if (optional) break block2;
                throw new JSONValidationException(String.format("required object '%s' is missing", docAttribute), (Exception)((Object)e));
            }
        }
    }

    private void validateArray(JSONObject doc, String docAttribute, JSONArray schemaArray, boolean optional) throws JSONValidationException {
        block2: {
            JSONArray docArray = null;
            try {
                docArray = doc.getJSONArray(docAttribute);
                this.validateArray(docArray, schemaArray);
            }
            catch (JSONException e) {
                if (optional) break block2;
                throw new JSONValidationException(String.format("required array '%s' is missing", docAttribute), (Exception)((Object)e));
            }
        }
    }

    private void validateAttribute(JSONObject doc, JSONObject schema, String attributeName) throws JSONValidationException {
        block8: {
            Object oAttribute = null;
            try {
                oAttribute = schema.get(attributeName);
            }
            catch (JSONException e) {
                _log.error("unexpected error", (Throwable)e);
                throw new JSONValidationException((Exception)((Object)e));
            }
            String docAttribute = this.getRealAttributeName(attributeName);
            boolean optional = this.isOptional(attributeName);
            if (oAttribute instanceof JSONObject) {
                this.validateObject(doc, docAttribute, (JSONObject)oAttribute, optional);
            } else if (oAttribute instanceof JSONArray) {
                this.validateArray(doc, docAttribute, (JSONArray)oAttribute, optional);
            } else {
                try {
                    this.validateValue(docAttribute, doc.get(docAttribute), (String)oAttribute);
                }
                catch (JSONException e) {
                    if (optional) break block8;
                    throw new JSONValidationException(String.format("error accessing attribute '%s'", docAttribute), (Exception)((Object)e));
                }
            }
        }
    }

    private void validateBoolean(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        if (!(value instanceof Boolean)) {
            throw new JSONValidationException(String.format("%s with value %s is not of type bool (boolean)", attribute, value));
        }
    }

    private String getDateFormatType(Map<String, String> validations) {
        String result = validations.get("format");
        if (null == result) {
            result = "date";
        }
        return result;
    }

    private DateFormat getDateFormat(String formatType) {
        DateFormat df = _dateFormats.get(formatType);
        if (null == df) {
            df = new SimpleDateFormat(formatType);
        }
        return df;
    }

    private void validateMinDate(String format, DateFormat df, Date date, String attribute, Map<String, String> validations) throws JSONValidationException {
        String min = validations.get(MIN);
        if (null != min) {
            try {
                Date minDate = df.parse(min);
                if (date.before(minDate)) {
                    throw new JSONValidationException(String.format("%s value '%s' for '%s' is before min %1$s '%s'", format, df.format(date), attribute, df.format(minDate)));
                }
            }
            catch (ParseException e) {
                throw new JSONValidationException(String.format("invalid min date schema definition '%s' for '%s'", min, attribute), e);
            }
        }
    }

    private void validateMaxDate(String format, DateFormat df, Date date, String attribute, Map<String, String> validations) throws JSONValidationException {
        String max = validations.get(MAX);
        if (null != max) {
            try {
                Date maxDate = df.parse(max);
                if (date.after(maxDate)) {
                    throw new JSONValidationException(String.format("%s value '%s' for '%s' is after max %1$s '%s'", format, df.format(date), attribute, df.format(maxDate)));
                }
            }
            catch (ParseException e) {
                throw new JSONValidationException(String.format("invalid max date schema definition '%s' for '%s'", max, attribute), e);
            }
        }
    }

    private void validateDate(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        if (value instanceof String) {
            String format = this.getDateFormatType(validations);
            DateFormat df = this.getDateFormat(format);
            try {
                Date date = df.parse((String)value);
                this.validateMinDate(format, df, date, attribute, validations);
                this.validateMaxDate(format, df, date, attribute, validations);
            }
            catch (ParseException e) {
                Date date = new Date();
                throw new JSONValidationException(String.format("date value '%s' for '%s' does not match required format '%s'", value, attribute, df.format(date)), e);
            }
        } else {
            throw new JSONValidationException(String.format("'%s' is a date and must be of type string; found %s", attribute, value));
        }
    }

    private JSONObject validateDocTypeDocument(JSONObject json, ISchemaProvider schemaProvider) throws JSONValidationException {
        JSONObject doc = this.assertChildObjectExists(json, "document");
        this.assertStringEquals(doc, "type", "instance");
        String namespace = this.assertStringExists(doc, "namespace");
        String id = this.assertStringExists(doc, "id");
        String version = this.assertStringExists(doc, "version");
        JSONObject schema = schemaProvider.getSchema(namespace, id, version);
        if (null == schema) {
            throw new JSONValidationException(String.format("schema missing for '%s-%s-%s'", namespace, id, version));
        }
        this.validateObject(json, schema, true);
        return doc;
    }

    private JSONObject validateDocTypeSchema(JSONObject json) throws JSONValidationException {
        JSONObject doc = this.assertChildObjectExists(json, "document");
        this.assertStringEquals(doc, "type", "schema");
        this.assertModelSupported(this.assertStringExists(doc, "model"));
        this.assertStringExists(doc, "namespace");
        this.assertStringExists(doc, "id");
        this.assertStringExists(doc, "version");
        return doc;
    }

    private void validateDouble(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        Double dblVal = this.getDouble(attribute, value);
        Double minVal = this.getDouble(attribute, validations, MIN);
        if (null != minVal && dblVal < minVal) {
            throw new JSONValidationException(String.format("%s = %f is out of range, min = %f", attribute, dblVal, minVal));
        }
        Double maxVal = this.getDouble(attribute, validations, MAX);
        if (null != maxVal && dblVal > maxVal) {
            throw new JSONValidationException(String.format("%s = %f is out of range, max = %f", attribute, dblVal, maxVal));
        }
    }

    private void validateEnum(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        if (value instanceof String) {
            String enumValue = ((String)value).trim().toLowerCase();
            String values = validations.get("values");
            HashSet<String> valueSet = new HashSet<String>();
            if (null != values) {
                for (String enumEntry : values.split("[,]")) {
                    if ((enumEntry = enumEntry.trim().toLowerCase()).length() <= 0) continue;
                    valueSet.add(enumEntry);
                }
            }
            if (valueSet.isEmpty()) {
                throw new JSONValidationException(String.format("enum schema for '%s' has no 'values'", attribute));
            }
            if (!valueSet.contains(enumValue)) {
                throw new JSONValidationException(String.format("enum '%s' value '%s' is not in enumeration '%s'", attribute, enumValue, values));
            }
        } else {
            throw new JSONValidationException(String.format("'%s' is an enum and must be of type string; found %s", attribute, value));
        }
    }

    private Double getDouble(String attribute, Map<String, String> validations, String key) throws JSONValidationException {
        Double result = null;
        String value = validations.get(key);
        if (null != value) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                throw new JSONValidationException(String.format("invalid schema : %s value of %s for %s", key, value, attribute), nfe);
            }
        }
        return result;
    }

    private Double getDouble(String attribute, Object value) throws JSONValidationException {
        Double dblVal = null;
        if (value instanceof Double) {
            dblVal = (Double)value;
        } else if (value instanceof String) {
            try {
                dblVal = Double.parseDouble((String)value);
            }
            catch (NumberFormatException nfe) {
                dblVal = null;
            }
        }
        if (null == dblVal) {
            throw new JSONValidationException(String.format("'%s' with value '%s' is not a valid double", attribute, value));
        }
        return dblVal;
    }

    private Integer getInt(String attribute, Map<String, String> validations, String key) throws JSONValidationException {
        Integer result = null;
        String value = validations.get(key);
        if (null != value) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new JSONValidationException(String.format("invalid schema : %s value of %s for %s", key, value, attribute), nfe);
            }
        }
        return result;
    }

    private Integer getInt(String attribute, Object value) throws JSONValidationException {
        Integer intVal = null;
        if (value instanceof Integer) {
            intVal = (Integer)value;
        } else if (value instanceof String) {
            try {
                intVal = Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                intVal = null;
            }
        }
        if (null == intVal) {
            throw new JSONValidationException(String.format("'%s' with value '%s' is not a valid integer", attribute, value));
        }
        return intVal;
    }

    private void validateInt(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        Integer intVal = this.getInt(attribute, value);
        Integer minVal = this.getInt(attribute, validations, MIN);
        if (null != minVal && intVal < minVal) {
            throw new JSONValidationException(String.format("%s = %d is out of range, min = %d", attribute, intVal, minVal));
        }
        Integer maxVal = this.getInt(attribute, validations, MAX);
        if (null != maxVal && intVal > maxVal) {
            throw new JSONValidationException(String.format("%s = %d is out of range, max = %d", attribute, intVal, maxVal));
        }
    }

    private Long getLong(String attribute, Map<String, String> validations, String key) throws JSONValidationException {
        Long result = null;
        String value = validations.get(key);
        if (null != value) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                throw new JSONValidationException(String.format("invalid schema : %s value of %s for %s", key, value, attribute), nfe);
            }
        }
        return result;
    }

    private Long getLong(String attribute, Object value) throws JSONValidationException {
        Long longVal = null;
        if (value instanceof Long) {
            longVal = (Long)value;
        } else if (value instanceof Integer) {
            Integer intVal = this.getInt(attribute, value);
            longVal = (long)intVal;
        } else if (value instanceof String) {
            try {
                longVal = Long.parseLong((String)value);
            }
            catch (NumberFormatException nfe) {
                longVal = null;
            }
        }
        if (null == longVal) {
            throw new JSONValidationException(String.format("'%s' with value '%s' is not a valid long number", attribute, value));
        }
        return longVal;
    }

    private void validateLong(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        Long longVal = this.getLong(attribute, value);
        Long minVal = this.getLong(attribute, validations, MIN);
        if (null != minVal && longVal < minVal) {
            throw new JSONValidationException(String.format("%s = %,d is out of range, min = %,d", attribute, longVal, minVal));
        }
        Long maxVal = this.getLong(attribute, validations, MAX);
        if (null != maxVal && longVal > maxVal) {
            throw new JSONValidationException(String.format("%s = %,d is out of range, max = %,d", attribute, longVal, maxVal));
        }
    }

    private void validateString(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        if (!(value instanceof String)) {
            throw new JSONValidationException(String.format("%s with value %s is not of type string", attribute, value));
        }
    }

    private void validateUuid(String attribute, Object value, Map<String, String> validations) throws JSONValidationException {
        if (value instanceof String) {
            Matcher matcher = _uuidPattern.matcher((String)value);
            if (!matcher.matches()) {
                throw new JSONValidationException(String.format("'%s' with value '%s' is not a valid uuid", attribute, value));
            }
        } else {
            throw new JSONValidationException(String.format("%s with value %s is not of type uuid", attribute, value));
        }
    }

    private void validateValue(String attribute, Object value, String validation) throws JSONValidationException {
        Map<String, String> validations = this.getValidations(validation);
        String type = validations.get("type");
        if (null != type) {
            switch (type) {
                case "int": {
                    this.validateInt(attribute, value, validations);
                    break;
                }
                case "long": {
                    this.validateLong(attribute, value, validations);
                    break;
                }
                case "date": {
                    this.validateDate(attribute, value, validations);
                    break;
                }
                case "double": {
                    this.validateDouble(attribute, value, validations);
                    break;
                }
                case "enum": {
                    this.validateEnum(attribute, value, validations);
                    break;
                }
                case "bool": {
                    this.validateBoolean(attribute, value, validations);
                    break;
                }
                case "uuid": {
                    this.validateUuid(attribute, value, validations);
                    break;
                }
                case "string": {
                    this.validateString(attribute, value, validations);
                    break;
                }
                default: {
                    throw new JSONValidationException(String.format("unsupported attribute type '%s'", type));
                }
            }
        } else {
            throw new JSONValidationException("required attribute 'type' is missing");
        }
    }

    static {
        _dateFormats.put("date", new SimpleDateFormat("yyyy-MM-dd"));
        _dateFormats.put("datetime", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSS Z"));
        _dateFormats.put("time", new SimpleDateFormat("HHmm"));
        _modelSet = new HashSet<String>();
        _modelSet.add("1311.0");
        _modelSet.add("1312.0");
    }
}

