/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.shaded.internal.connection;

import java.io.IOException;
import okhttp3.shaded.Interceptor;
import okhttp3.shaded.OkHttpClient;
import okhttp3.shaded.Request;
import okhttp3.shaded.Response;
import okhttp3.shaded.internal.connection.RealConnection;
import okhttp3.shaded.internal.connection.StreamAllocation;
import okhttp3.shaded.internal.http.HttpStream;
import okhttp3.shaded.internal.http.RealInterceptorChain;

public final class ConnectInterceptor
implements Interceptor {
    public final OkHttpClient client;

    public ConnectInterceptor(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = realChain.request();
        StreamAllocation streamAllocation = realChain.streamAllocation();
        boolean doExtensiveHealthChecks = !request.method().equals("GET");
        HttpStream httpStream = streamAllocation.newStream(this.client, doExtensiveHealthChecks);
        RealConnection connection = streamAllocation.connection();
        return realChain.proceed(request, streamAllocation, httpStream, connection);
    }
}

