/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.shaded.ws;

import java.io.IOException;
import java.net.ProtocolException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.shaded.Call;
import okhttp3.shaded.Callback;
import okhttp3.shaded.OkHttpClient;
import okhttp3.shaded.Protocol;
import okhttp3.shaded.Request;
import okhttp3.shaded.Response;
import okhttp3.shaded.internal.Internal;
import okhttp3.shaded.internal.Util;
import okhttp3.shaded.internal.connection.StreamAllocation;
import okhttp3.shaded.internal.ws.RealWebSocket;
import okhttp3.shaded.ws.WebSocketListener;
import okio.shaded.ByteString;

public final class WebSocketCall {
    private final Call call;
    private final Random random;
    private final String key;

    public static WebSocketCall create(OkHttpClient client, Request request) {
        return new WebSocketCall(client, request);
    }

    WebSocketCall(OkHttpClient client, Request request) {
        this(client, request, new SecureRandom());
    }

    WebSocketCall(OkHttpClient client, Request request, Random random) {
        if (!"GET".equals(request.method())) {
            throw new IllegalArgumentException("Request must be GET: " + request.method());
        }
        this.random = random;
        byte[] nonce = new byte[16];
        random.nextBytes(nonce);
        this.key = ByteString.of(nonce).base64();
        client = client.newBuilder().protocols(Collections.singletonList(Protocol.HTTP_1_1)).build();
        request = request.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = client.newCall(request);
    }

    public void enqueue(final WebSocketListener listener) {
        Callback responseCallback = new Callback(){

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                try {
                    WebSocketCall.this.createWebSocket(response, listener);
                }
                catch (IOException e) {
                    listener.onFailure(e, response);
                }
            }

            @Override
            public void onFailure(Call call, IOException e) {
                listener.onFailure(e, null);
            }
        };
        Internal.instance.setCallWebSocket(this.call);
        this.call.enqueue(responseCallback);
    }

    public void cancel() {
        this.call.cancel();
    }

    private void createWebSocket(Response response, WebSocketListener listener) throws IOException {
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + " " + response.message() + "'");
        }
        String headerConnection = response.header("Connection");
        if (!"Upgrade".equalsIgnoreCase(headerConnection)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + "'");
        }
        String headerUpgrade = response.header("Upgrade");
        if (!"websocket".equalsIgnoreCase(headerUpgrade)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + "'");
        }
        String headerAccept = response.header("Sec-WebSocket-Accept");
        String acceptExpected = Util.shaBase64(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
        if (!acceptExpected.equals(headerAccept)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + acceptExpected + "' but was '" + headerAccept + "'");
        }
        StreamAllocation streamAllocation = Internal.instance.callEngineGetStreamAllocation(this.call);
        RealWebSocket webSocket = StreamWebSocket.create(streamAllocation, response, this.random, listener);
        listener.onOpen(webSocket, response);
        while (webSocket.readMessage()) {
        }
    }

    private static class StreamWebSocket
    extends RealWebSocket {
        private final StreamAllocation streamAllocation;
        private final ExecutorService replyExecutor;

        static RealWebSocket create(StreamAllocation streamAllocation, Response response, Random random, WebSocketListener listener) {
            String url = response.request().url().toString();
            ThreadPoolExecutor replyExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Util.threadFactory(Util.format("OkHttp %s WebSocket", url), true));
            replyExecutor.allowCoreThreadTimeOut(true);
            return new StreamWebSocket(streamAllocation, random, replyExecutor, listener, url);
        }

        private StreamWebSocket(StreamAllocation streamAllocation, Random random, ExecutorService replyExecutor, WebSocketListener listener, String url) {
            super(true, streamAllocation.connection().source, streamAllocation.connection().sink, random, replyExecutor, listener, url);
            this.streamAllocation = streamAllocation;
            this.replyExecutor = replyExecutor;
        }

        @Override
        protected void close() throws IOException {
            this.replyExecutor.shutdown();
            this.streamAllocation.noNewStreams();
            this.streamAllocation.streamFinished(true, this.streamAllocation.stream());
        }
    }
}

