/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.agent.javaagent.JavaAgentEngine;

public class JavaAgent {
    private static boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            JavaAgent.start(args);
        }
        catch (Exception e) {
            System.err.println("Hawkular Java Agent failed at startup");
            e.printStackTrace(System.err);
            return;
        }
        Class<JavaAgent> clazz = JavaAgent.class;
        synchronized (JavaAgent.class) {
            try {
                JavaAgent.class.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public static void premain(String args) {
        if (args == null) {
            args = "config=config.yaml";
        }
        try {
            JavaAgent.start(args.split(","));
        }
        catch (Exception e) {
            System.err.println("Hawkular Java Agent failed at startup");
            e.printStackTrace(System.err);
        }
    }

    private static synchronized void start(String[] args) throws Exception {
        if (started) {
            return;
        }
        if (args == null || args.length == 0) {
            args = new String[]{"config=config.yaml"};
        }
        String configFilePathString = "config.yaml";
        final AtomicInteger delaySeconds = new AtomicInteger(0);
        for (String arg : args) {
            String[] nameValueArg = arg.split("=", 2);
            if (nameValueArg.length != 2) continue;
            if ("config".equals(nameValueArg[0])) {
                configFilePathString = nameValueArg[1];
            }
            if (!"delay".equals(nameValueArg[0])) continue;
            delaySeconds.set(Integer.parseInt(nameValueArg[1]));
        }
        final File configFile = new File(configFilePathString);
        if (!configFile.canRead()) {
            throw new Exception("Missing configuration file: " + configFile.getAbsolutePath());
        }
        Thread agentThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (delaySeconds.get() > 0) {
                        Thread.sleep(delaySeconds.get() * 1000);
                    }
                    new JavaAgentEngine(configFile).startHawkularAgent();
                }
                catch (Exception e) {
                    System.err.println("Hawkular Java Agent failed at startup");
                    e.printStackTrace(System.err);
                }
            }
        }, "Hawkular Java Agent Start Thread");
        agentThread.setDaemon(true);
        agentThread.start();
        started = true;
    }
}

