/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonValue;

public abstract class AbstractStringifiedProperty<T> {
    protected final T defaultValue;
    protected String valueAsString;

    public AbstractStringifiedProperty() {
        this.defaultValue = null;
        this.set(null);
    }

    public AbstractStringifiedProperty(T defaultVal) {
        this.defaultValue = defaultVal;
        this.set(defaultVal);
    }

    public AbstractStringifiedProperty(String str) {
        this.defaultValue = null;
        this.setValueAsString(str);
    }

    public AbstractStringifiedProperty(AbstractStringifiedProperty<T> original) {
        if (original != null) {
            this.defaultValue = original.defaultValue;
            this.valueAsString = original.valueAsString;
        } else {
            this.defaultValue = null;
            this.set(null);
        }
    }

    public T get() {
        return this.deserialize(this.valueAsString);
    }

    public void set(T value) {
        this.setValueAsString(this.serialize(value != null ? value : this.defaultValue));
    }

    public String getValueAsString() {
        return this.valueAsString;
    }

    public void setValueAsString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Expression string must not be null");
        }
        this.valueAsString = str;
    }

    @JsonValue
    public String toString() {
        return this.getValueAsString();
    }

    protected abstract T deserialize(String var1);

    protected abstract String serialize(T var1);
}

