/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.DMRResourceType;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRResourceTypeSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="resource-type-dmr")
    private DMRResourceType[] dmrResourceTypes;

    public DMRResourceTypeSet() {
    }

    public DMRResourceTypeSet(DMRResourceTypeSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.dmrResourceTypes = Util.cloneArray(original.dmrResourceTypes);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-type-set-dmr name must be specified");
        }
        if (this.dmrResourceTypes != null) {
            for (DMRResourceType o : this.dmrResourceTypes) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DMRResourceType[] getDmrResourceTypes() {
        return this.dmrResourceTypes;
    }

    public void setDmrResourceTypes(DMRResourceType[] dmrResourceTypes) {
        this.dmrResourceTypes = dmrResourceTypes;
    }
}

