/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Diagnostics
implements Validatable {
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty
    private Integer interval = 5;
    @JsonProperty(value="time-units")
    private TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="report-to")
    private ReportTo reportTo = ReportTo.LOG;

    public Diagnostics() {
    }

    public Diagnostics(Diagnostics original) {
        this.enabled = original.enabled;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.reportTo = original.reportTo;
    }

    @Override
    public void validate() throws Exception {
        if (this.interval == null || this.interval < 0) {
            throw new Exception("diagnostics interval must be greater than or equal to 0");
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public TimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(TimeUnits timeUnits) {
        this.timeUnits = timeUnits;
    }

    public ReportTo getReportTo() {
        return this.reportTo;
    }

    public void setReportTo(ReportTo reportTo) {
        this.reportTo = reportTo;
    }

    public static enum ReportTo {
        LOG,
        STORAGE;

    }
}

