/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXAvail;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXAvailSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="avail-jmx")
    private JMXAvail[] jmxAvails;

    public JMXAvailSet() {
    }

    public JMXAvailSet(JMXAvailSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.jmxAvails = Util.cloneArray(original.jmxAvails);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("avail-set-jmx name must be specified");
        }
        if (this.jmxAvails != null) {
            for (JMXAvail o : this.jmxAvails) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public JMXAvail[] getJmxAvails() {
        return this.jmxAvails;
    }

    public void setJmxAvails(JMXAvail[] jmxAvails) {
        this.jmxAvails = jmxAvails;
    }
}

