/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXMetric;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXMetricSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="metric-jmx")
    private JMXMetric[] jmxMetrics;

    public JMXMetricSet() {
    }

    public JMXMetricSet(JMXMetricSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.jmxMetrics = Util.cloneArray(original.jmxMetrics);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("metric-set-jmx name must be specified");
        }
        if (this.jmxMetrics != null) {
            for (JMXMetric o : this.jmxMetrics) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public JMXMetric[] getJmxMetrics() {
        return this.jmxMetrics;
    }

    public void setJmxMetrics(JMXMetric[] jmxMetrics) {
        this.jmxMetrics = jmxMetrics;
    }
}

