/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.concurrent.TimeUnit;

public class Interval {
    private final TimeUnit unit;
    private final int val;

    public Interval(int val, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Missing units");
        }
        this.val = val;
        this.unit = unit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return this.val == other.val;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getVal() {
        return this.val;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.val;
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public long millis() {
        return TimeUnit.MILLISECONDS.convert(this.val, this.unit);
    }

    public long seconds() {
        return TimeUnit.SECONDS.convert(this.val, this.unit);
    }

    public String toString() {
        return "Interval[" + this.val + " " + this.unit.name() + "]";
    }
}

