/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NodeLocationProvider;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.client.api.NotificationType;

public final class ResourceType<L>
extends NodeLocationProvider<L> {
    private final String resourceNameTemplate;
    private final Collection<Name> parents;
    private final Collection<Name> metricSetNames;
    private final Collection<Name> availSetNames;
    private final Collection<MetricType<L>> metricTypes;
    private final Collection<AvailType<L>> availTypes;
    private final Collection<NotificationType> notifications;
    private final Collection<Operation<L>> operations;
    private final Collection<ResourceConfigurationPropertyType<L>> resourceConfigurationPropertyTypes;

    public static <L> Builder<Builder<?, L>, L> builder() {
        return new Builder();
    }

    private ResourceType(ID id, Name name, L location, String resourceNameTemplate, Collection<Name> parents, Collection<Name> metricSetNames, Collection<Name> availSetNames, Collection<MetricType<L>> metricTypes, Collection<AvailType<L>> availTypes, Collection<NotificationType> notifications, Collection<Operation<L>> operations, Collection<ResourceConfigurationPropertyType<L>> resourceConfigurationPropertyTypes) {
        super(id, name, location);
        this.resourceNameTemplate = resourceNameTemplate;
        this.parents = parents;
        this.metricSetNames = metricSetNames;
        this.availSetNames = availSetNames;
        this.metricTypes = metricTypes;
        this.availTypes = availTypes;
        this.notifications = notifications;
        this.operations = operations;
        this.resourceConfigurationPropertyTypes = resourceConfigurationPropertyTypes;
    }

    public String getResourceNameTemplate() {
        return this.resourceNameTemplate;
    }

    public Collection<Name> getParents() {
        return this.parents;
    }

    public Collection<NotificationType> getNotifications() {
        return this.notifications;
    }

    public Collection<Name> getMetricSets() {
        return this.metricSetNames;
    }

    public Collection<Name> getAvailSets() {
        return this.availSetNames;
    }

    public Collection<MetricType<L>> getMetricTypes() {
        return this.metricTypes;
    }

    public Collection<AvailType<L>> getAvailTypes() {
        return this.availTypes;
    }

    public Collection<ResourceConfigurationPropertyType<L>> getResourceConfigurationPropertyTypes() {
        return this.resourceConfigurationPropertyTypes;
    }

    public Collection<Operation<L>> getOperations() {
        return this.operations;
    }

    public static class Builder<This extends Builder<?, L>, L>
    extends NodeLocationProvider.Builder<This, L> {
        private String resourceNameTemplate;
        private List<Name> parents = new ArrayList<Name>();
        private List<Name> metricSetNames = new ArrayList<Name>();
        private List<Name> availSetNames = new ArrayList<Name>();
        private List<MetricType<L>> metricTypes = new ArrayList<MetricType<L>>();
        private List<AvailType<L>> availTypes = new ArrayList<AvailType<L>>();
        private List<NotificationType> notificationTypes = new ArrayList<NotificationType>();
        private List<Operation<L>> operations = new ArrayList<Operation<L>>();
        private List<ResourceConfigurationPropertyType<L>> resourceConfigurationPropertyTypes = new ArrayList<ResourceConfigurationPropertyType<L>>();

        private Builder() {
        }

        public ResourceType<L> build() {
            return new ResourceType(this.id, this.name, this.location, this.resourceNameTemplate, Collections.unmodifiableList(this.parents), Collections.unmodifiableList(this.metricSetNames), Collections.unmodifiableList(this.availSetNames), Collections.unmodifiableList(this.metricTypes), Collections.unmodifiableList(this.availTypes), Collections.unmodifiableList(this.notificationTypes), Collections.unmodifiableList(this.operations), Collections.unmodifiableList(this.resourceConfigurationPropertyTypes));
        }

        private This getThis() {
            return (This)this;
        }

        public This availSetName(Name name) {
            this.availSetNames.add(name);
            return this.getThis();
        }

        public This availSetNames(Collection<Name> names) {
            this.availSetNames.addAll(names);
            return this.getThis();
        }

        public This metricSetName(Name name) {
            this.metricSetNames.add(name);
            return this.getThis();
        }

        public This metricSetNames(Collection<Name> names) {
            this.metricSetNames.addAll(names);
            return this.getThis();
        }

        public This availTypes(Collection<AvailType<L>> types) {
            this.availTypes.addAll(types);
            return this.getThis();
        }

        public This metricTypes(Collection<MetricType<L>> types) {
            this.metricTypes.addAll(types);
            return this.getThis();
        }

        public This operation(Operation<L> operation) {
            this.operations.add(operation);
            return this.getThis();
        }

        public This parent(Name name) {
            this.parents.add(name);
            return this.getThis();
        }

        public This parents(Collection<Name> names) {
            this.parents.addAll(names);
            return this.getThis();
        }

        public This notificationType(NotificationType notificationType) {
            this.notificationTypes.add(notificationType);
            return this.getThis();
        }

        public This notificationTypes(Collection<NotificationType> notificationTypes) {
            this.notificationTypes.addAll(notificationTypes);
            return this.getThis();
        }

        public This resourceNameTemplate(String resourceNameTemplate) {
            this.resourceNameTemplate = resourceNameTemplate;
            return this.getThis();
        }

        public This resourceConfigurationPropertyType(ResourceConfigurationPropertyType<L> resourceConfigurationPropertyType) {
            this.resourceConfigurationPropertyTypes.add(resourceConfigurationPropertyType);
            return this.getThis();
        }

        public List<Name> getAvailSetNames() {
            return Collections.unmodifiableList(this.availSetNames);
        }

        public List<Name> getMetricSetNames() {
            return Collections.unmodifiableList(this.metricSetNames);
        }
    }
}

