/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.shaded.jgrapht.alg.DirectedNeighborIndex;
import org.shaded.jgrapht.graph.DefaultEdge;
import org.shaded.jgrapht.graph.ListenableDirectedGraph;
import org.shaded.jgrapht.traverse.BreadthFirstIterator;

public final class ResourceTypeManager<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(ResourceTypeManager.class);
    private final ListenableDirectedGraph<ResourceType<L>, DefaultEdge> resourceTypesGraph;
    private final DirectedNeighborIndex<ResourceType<L>, DefaultEdge> index;
    private final Map<Name, TypeSet<ResourceType<L>>> typeSetMap;

    public ResourceTypeManager(Collection<ResourceType<L>> allTypes) {
        this(ResourceTypeManager.buildTypeMapForConstructor(allTypes), null);
    }

    private static <L> Map<Name, TypeSet<ResourceType<L>>> buildTypeMapForConstructor(Collection<ResourceType<L>> allTypes) {
        TypeSet.TypeSetBuilder<ResourceType<L>> bldr = TypeSet.builder();
        bldr.enabled(true);
        bldr.name(new Name("all"));
        for (ResourceType<L> type : allTypes) {
            bldr.type(type);
        }
        TypeSet typeSet = bldr.build();
        return Collections.singletonMap(typeSet.getName(), typeSet);
    }

    public ResourceTypeManager(Map<Name, TypeSet<ResourceType<L>>> resourceTypeSetMap, Collection<Name> setsToUse) throws IllegalStateException {
        if (setsToUse == null) {
            this.typeSetMap = resourceTypeSetMap;
        } else {
            HashMap<Name, TypeSet<ResourceType<L>>> m = new HashMap<Name, TypeSet<ResourceType<L>>>();
            for (Name setToUse : setsToUse) {
                if (!resourceTypeSetMap.containsKey(setToUse)) continue;
                m.put(setToUse, resourceTypeSetMap.get(setToUse));
            }
            this.typeSetMap = Collections.unmodifiableMap(m);
        }
        this.resourceTypesGraph = new ListenableDirectedGraph(DefaultEdge.class);
        this.index = new DirectedNeighborIndex<ResourceType<L>, DefaultEdge>(this.resourceTypesGraph);
        this.resourceTypesGraph.addGraphListener(this.index);
        this.prepareGraph();
    }

    public List<ResourceType<L>> getResourceTypesBreadthFirst() {
        ArrayList result = new ArrayList();
        BreadthFirstIterator<ResourceType<L>, DefaultEdge> it = new BreadthFirstIterator<ResourceType<L>, DefaultEdge>(this.resourceTypesGraph);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return Collections.unmodifiableList(result);
    }

    public Set<ResourceType<L>> getRootResourceTypes() {
        HashSet<ResourceType> roots = new HashSet<ResourceType>();
        Set allTypes = this.resourceTypesGraph.vertexSet();
        for (ResourceType type : allTypes) {
            if (!this.index.predecessorsOf(type).isEmpty()) continue;
            if (type.getParents().isEmpty()) {
                roots.add(type);
                continue;
            }
            log.errorInvalidRootResourceType(type.getID().getIDString(), type.getParents());
        }
        return Collections.unmodifiableSet(roots);
    }

    public Set<ResourceType<L>> getChildren(ResourceType<L> resourceType) {
        Set<ResourceType<L>> directChildren = this.index.successorsOf(resourceType);
        return Collections.unmodifiableSet(directChildren);
    }

    public Set<ResourceType<L>> getParents(ResourceType<L> resourceType) {
        Set<ResourceType<L>> directParents = this.index.predecessorsOf(resourceType);
        return Collections.unmodifiableSet(directParents);
    }

    private void prepareGraph() throws IllegalStateException {
        ArrayList<ResourceType<L>> disabledTypes = new ArrayList<ResourceType<L>>();
        HashMap<Name, ResourceType<L>> allResourceTypes = new HashMap<Name, ResourceType<L>>();
        for (TypeSet<ResourceType<L>> rTypeSet : this.typeSetMap.values()) {
            for (ResourceType<L> rType : rTypeSet.getTypeMap().values()) {
                if (null != allResourceTypes.put(rType.getName(), rType)) {
                    throw new IllegalStateException("Multiple resource types have the same name: " + rType.getName());
                }
                this.resourceTypesGraph.addVertex(rType);
                if (rTypeSet.isEnabled()) continue;
                disabledTypes.add(rType);
            }
        }
        for (TypeSet<ResourceType<L>> rTypeSet : this.typeSetMap.values()) {
            for (ResourceType<L> rType : rTypeSet.getTypeMap().values()) {
                for (Name parent : rType.getParents()) {
                    ResourceType parentResourceType = (ResourceType)allResourceTypes.get(parent);
                    if (parentResourceType == null) {
                        log.debugf("Resource type [%s] will ignore unknown parent [%s]", (Object)rType.getName(), (Object)parent);
                        continue;
                    }
                    this.resourceTypesGraph.addEdge(parentResourceType, rType);
                }
            }
        }
        ArrayList<ResourceType<L>> toBeDisabled = new ArrayList<ResourceType<L>>();
        for (ResourceType resourceType : disabledTypes) {
            toBeDisabled.add(resourceType);
            this.getDeepChildrenList(resourceType, toBeDisabled);
            log.infoDisablingResourceTypes(resourceType, toBeDisabled);
        }
        this.resourceTypesGraph.removeAllVertices(toBeDisabled);
    }

    private void getDeepChildrenList(ResourceType<L> resourceType, List<ResourceType<L>> children) {
        Set<ResourceType<L>> directChildren = this.getChildren(resourceType);
        children.addAll(directChildren);
        for (ResourceType<L> child : directChildren) {
            this.getDeepChildrenList(child, children);
        }
    }
}

