/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import java.util.ArrayList;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.Property;

public class DMRLocationResolver
implements LocationResolver<DMRNodeLocation> {
    private static boolean matches(int length, PathAddress pattern, PathAddress address) {
        for (int i = 0; i < length; ++i) {
            PathElement otherElem = address.getElement(i);
            Property prop = new Property(otherElem.getKey(), new ModelNode(otherElem.getValue()));
            if (pattern.getElement(i).matches(prop)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DMRNodeLocation buildLocation(String path) throws Exception {
        return DMRNodeLocation.of(path);
    }

    @Override
    public String findWildcardMatch(DMRNodeLocation multiTargetLocation, DMRNodeLocation singleLocation) throws ProtocolException {
        if (multiTargetLocation == null) {
            throw new ProtocolException("multiTargetLocation is null");
        }
        PathAddress multiTargetPaths = multiTargetLocation.getPathAddress();
        for (int i = 0; i < multiTargetPaths.size(); ++i) {
            PathElement singleLocationPathElement;
            PathElement multiTargetPathElement = multiTargetPaths.getElement(i);
            if (!multiTargetPathElement.isWildcard()) continue;
            try {
                singleLocationPathElement = singleLocation.getPathAddress().getElement(i);
            }
            catch (Exception e) {
                throw new ProtocolException(String.format("[%s] doesn't have the same path size as [%s]", singleLocation, multiTargetLocation));
            }
            if (singleLocationPathElement.getKey().equals(multiTargetPathElement.getKey())) {
                return singleLocationPathElement.getValue();
            }
            throw new ProtocolException(String.format("[%s] doesn't match the multi-target key in [%s]", singleLocation, multiTargetLocation));
        }
        throw new ProtocolException(String.format("[%s] doesn't match the wildcard from [%s]", singleLocation, multiTargetLocation));
    }

    @Override
    public boolean isMultiTarget(DMRNodeLocation location) {
        return location.getPathAddress().isMultiTarget();
    }

    @Override
    public DMRNodeLocation absolutize(DMRNodeLocation base, DMRNodeLocation location) {
        if (base == null || base.getPathAddress().equals(PathAddress.EMPTY_ADDRESS)) {
            return location;
        }
        if (location == null) {
            return base;
        }
        PathAddress basePath = base.getPathAddress();
        PathAddress path = location.getPathAddress();
        if (path.equals(PathAddress.EMPTY_ADDRESS)) {
            return new DMRNodeLocation(base.getPathAddress(), location.getResolveExpressions(), location.getIncludeDefaults());
        }
        ArrayList<PathElement> segments = new ArrayList<PathElement>(basePath.size() + path.size());
        for (PathElement segment : basePath) {
            segments.add(segment);
        }
        for (PathElement segment : path) {
            segments.add(segment);
        }
        PathAddress absPath = PathAddress.pathAddress(segments);
        return new DMRNodeLocation(absPath, location.getResolveExpressions(), location.getIncludeDefaults());
    }

    @Override
    public boolean isParent(DMRNodeLocation parent, DMRNodeLocation child) {
        if (parent == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParent() with a null parent argument");
        }
        if (child == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParent() with a null child argument");
        }
        PathAddress parentPath = parent.getPathAddress();
        PathAddress childPath = child.getPathAddress();
        int parentLength = parentPath.size();
        if (parentLength < childPath.size()) {
            return DMRLocationResolver.matches(parentLength, parentPath, childPath);
        }
        return false;
    }

    @Override
    public boolean matches(DMRNodeLocation query, DMRNodeLocation location) {
        if (query == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].matches() with a null query argument");
        }
        PathAddress queryPath = query.getPathAddress();
        PathAddress path = location.getPathAddress();
        int queryLength = queryPath.size();
        if (queryLength == path.size()) {
            return DMRLocationResolver.matches(queryLength, queryPath, path);
        }
        return false;
    }

    @Override
    public String applyTemplate(String nameTemplate, DMRNodeLocation location, String endpointName) {
        ArrayList<String> args = new ArrayList<String>();
        for (PathElement segment : location.getPathAddress()) {
            args.add(segment.getKey());
            args.add(segment.getValue());
        }
        nameTemplate = nameTemplate.replaceAll("%(\\d+)", "%$1\\$s");
        nameTemplate = nameTemplate.replaceAll("%(-)", "%" + args.size() + "\\$s");
        nameTemplate = nameTemplate.replaceAll("%ManagedServerName", endpointName);
        String nameStr = String.format(nameTemplate, args.toArray());
        return nameStr;
    }
}

