/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.ResourceTypeManager;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.jmx.JMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.JMXLocationResolver;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXSession;
import org.hawkular.agent.monitor.protocol.jmx.JolokiaClientFactory;
import org.hawkular.agent.monitor.protocol.jmx.JolokiaJMXDriver;
import org.hawkular.agent.monitor.protocol.jmx.MBeanServerConnectionJMXDriver;
import org.shaded.jolokia.client.J4pClient;

public class JMXEndpointService
extends EndpointService<JMXNodeLocation, JMXSession> {
    public static final String MBEAN_SERVER_NAME_KEY = "mbean-server-name";
    private final JolokiaClientFactory clientFactory;

    public JMXEndpointService(String feedId, MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint, ResourceTypeManager<JMXNodeLocation> resourceTypeManager, ProtocolDiagnostics diagnostics) {
        super(feedId, endpoint, resourceTypeManager, new JMXLocationResolver(), diagnostics);
        this.clientFactory = endpoint.getConnectionData() != null ? new JolokiaClientFactory(endpoint) : null;
    }

    @Override
    public JMXSession openSession() {
        JMXDriver driver;
        if (this.clientFactory != null) {
            J4pClient client = this.clientFactory.createClient();
            driver = new JolokiaJMXDriver(this.getDiagnostics(), client);
        } else {
            MBeanServerConnection mbs = this.getMBeanServerConnection();
            driver = new MBeanServerConnectionJMXDriver(this.getDiagnostics(), mbs);
        }
        return new JMXSession(this.getFeedId(), (MonitoredEndpoint)this.getMonitoredEndpoint(), this.getResourceTypeManager(), driver, this.getLocationResolver());
    }

    private MBeanServerConnection getMBeanServerConnection() {
        Object nameObj;
        String mbsName = null;
        Map<String, ? extends Object> customData = this.getMonitoredEndpoint().getEndpointConfiguration().getCustomData();
        if (customData != null && (nameObj = customData.get(MBEAN_SERVER_NAME_KEY)) != null && !nameObj.toString().isEmpty()) {
            mbsName = nameObj.toString();
        }
        MBeanServer mbs = null;
        if (mbsName != null) {
            ArrayList<MBeanServer> allMbs = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer curMbs : allMbs) {
                if (curMbs == null || !mbsName.equals(curMbs.getDefaultDomain())) continue;
                mbs = curMbs;
                break;
            }
        }
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return mbs;
    }
}

