/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.jmx;

import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;

public class JMXLocationResolver
implements LocationResolver<JMXNodeLocation> {
    @Override
    public JMXNodeLocation buildLocation(String path) throws Exception {
        return new JMXNodeLocation(path);
    }

    @Override
    public String findWildcardMatch(JMXNodeLocation multiTargetLocation, JMXNodeLocation singleLocation) throws ProtocolException {
        if (multiTargetLocation == null) {
            throw new ProtocolException("multiTargetLocation is null");
        }
        for (String multiTargetPathKey : multiTargetLocation.getCanonicalKeys()) {
            String multiTargetPathValue = multiTargetLocation.getObjectName().getKeyProperty(multiTargetPathKey);
            if (!"*".equals(multiTargetPathValue)) continue;
            String singleLocationPathValue = singleLocation.getObjectName().getKeyProperty(multiTargetPathKey);
            if (singleLocationPathValue != null) {
                return singleLocationPathValue;
            }
            throw new ProtocolException(String.format("[%s] doesn't match the multi-target key in [%s]", singleLocation, multiTargetLocation));
        }
        throw new ProtocolException(String.format("[%s] doesn't match the wildcard from [%s]", singleLocation, multiTargetLocation));
    }

    @Override
    public boolean isMultiTarget(JMXNodeLocation location) {
        return location.getObjectName().isPattern();
    }

    @Override
    public JMXNodeLocation absolutize(JMXNodeLocation base, JMXNodeLocation location) {
        return location != null && location.getObjectName() != null ? location : base;
    }

    @Override
    public boolean isParent(JMXNodeLocation parent, JMXNodeLocation child) {
        int childKeyCount;
        if (parent == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParent() with a null parent argument");
        }
        if (child == null) {
            throw new IllegalArgumentException("Cannot compute [" + this.getClass().getName() + "].isParent() with a null child argument");
        }
        ObjectName parentObjectName = parent.getObjectName();
        ObjectName childObjectName = child.getObjectName();
        if (!parentObjectName.getDomain().equals(childObjectName.getDomain())) {
            return false;
        }
        int parentKeyCount = parent.getCanonicalKeys().size();
        if (parentKeyCount >= (childKeyCount = child.getCanonicalKeys().size())) {
            return false;
        }
        for (String parentKey : parent.getCanonicalKeys()) {
            String parentKeyValue = parentObjectName.getKeyProperty(parentKey);
            if (parentKeyValue.equals(childObjectName.getKeyProperty(parentKey))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(JMXNodeLocation query, JMXNodeLocation location) {
        return query.getObjectName().apply(location.getObjectName());
    }

    @Override
    public String applyTemplate(String nameTemplate, JMXNodeLocation location, String endpointName) {
        nameTemplate = nameTemplate.replace("%_ManagedServerName%", endpointName);
        for (Map.Entry<String, String> entry : location.getObjectName().getKeyPropertyList().entrySet()) {
            if (nameTemplate.indexOf("%") == -1) break;
            String key = entry.getKey();
            String value = entry.getValue();
            nameTemplate = nameTemplate.replace("%" + key + "%", value);
        }
        return nameTemplate;
    }
}

