/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.Set;
import org.hawkular.agent.monitor.api.SamplingService;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.MeasurementCollector;
import org.hawkular.agent.monitor.scheduler.ScheduledCollectionsQueue;
import org.hawkular.agent.monitor.storage.MetricDataPoint;
import org.hawkular.agent.monitor.util.Consumer;

class MetricsCollector<L>
extends MeasurementCollector<L, MetricType<L>, MetricDataPoint>
implements Runnable {
    static final MsgLogger LOG = AgentLoggers.getLogger(MetricsCollector.class);

    public MetricsCollector(SamplingService<L> endpointService, ScheduledCollectionsQueue<L, MetricType<L>> priorityQueue, Consumer<MetricDataPoint> completionHandler) {
        super(endpointService, priorityQueue, completionHandler);
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                ScheduledCollectionsQueue queue = this.getScheduledCollectionsQueue();
                long next = queue.getNextExpectedCollectionTime();
                if (next == Long.MIN_VALUE) {
                    Thread.sleep(10000L);
                    continue;
                }
                long delay = next - System.currentTimeMillis();
                if (delay <= 0L) {
                    Set instances = queue.popNextScheduledSet();
                    this.getEndpointService().measureMetrics(instances, new Consumer<MetricDataPoint>(){

                        @Override
                        public void accept(MetricDataPoint dataPoint) {
                            MetricsCollector.this.getCompletionHandler().accept(dataPoint);
                        }

                        @Override
                        public void report(Throwable e) {
                            LOG.errorFailedToStoreMetrics(MetricsCollector.this.getEndpointService().toString(), e);
                            MetricsCollector.this.getCompletionHandler().report(e);
                        }
                    });
                    continue;
                }
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (IllegalStateException ise) {
                LOG.debugf("Cannot collect metrics for endpoint [%s] - not ready yet: %s", (Object)this.getEndpointService(), (Object)ise);
            }
            catch (Throwable t) {
                LOG.warnf(t, "Unexpected error caught in MetricsCollector for endpoint [%s]", (Object)this.getEndpointService());
            }
        }
    }
}

