/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryListener;
import org.hawkular.agent.monitor.api.NotificationPayloadBuilder;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.storage.StorageAdapter;
import org.hawkular.client.api.NotificationType;
import org.hawkular.inventory.paths.CanonicalPath;

public class NotificationDispatcher
implements InventoryListener {
    StorageAdapter storageAdapter;
    String feedId;

    public NotificationDispatcher(StorageAdapter storageAdapter, String feedId) {
        this.storageAdapter = storageAdapter;
        this.feedId = feedId;
    }

    @Override
    public <L> void receivedEvent(InventoryEvent<L> event) {
        MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
        String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
        String tenantId = null != endpointTenantId ? endpointTenantId : this.storageAdapter.getStorageAdapterConfiguration().getTenantId();
        event.getAddedOrModified().stream().filter(r -> r.getResourceType().getNotifications().contains((Object)NotificationType.RESOURCE_ADDED)).forEach(r -> {
            CanonicalPath cp = (CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(this.feedId)).resource(r.getID().getIDString())).get();
            try {
                NotificationPayloadBuilder b = this.storageAdapter.createNotificationPayloadBuilder();
                b.addNotificationType(NotificationType.RESOURCE_ADDED);
                b.addProperty("resourceType", r.getResourceType().getName().getNameString());
                b.addProperty("resourcePath", cp.toString());
                this.storageAdapter.store(b, 0L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

