/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;

public class WildflyCompatibilityUtils {
    public static PathAddress parseCLIStyleAddress(String address) throws IllegalArgumentException {
        try {
            return PathAddress.parseCLIStyleAddress(address);
        }
        catch (NoSuchMethodError _nsme) {
            return WildflyCompatibilityUtils._parseCLIStyleAddress(address);
        }
    }

    private static PathAddress _parseCLIStyleAddress(String address) throws IllegalArgumentException {
        PathAddress parsedAddress = PathAddress.EMPTY_ADDRESS;
        if (address == null || address.trim().isEmpty()) {
            return parsedAddress;
        }
        String trimmedAddress = address.trim();
        if (trimmedAddress.charAt(0) != '/' || !Character.isAlphabetic(trimmedAddress.charAt(1))) {
            throw new IllegalArgumentException("Illegal path address '" + address + "' , it is not in a correct CLI format");
        }
        char[] characters = address.toCharArray();
        boolean escaped = false;
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        StringBuilder currentBuffer = keyBuffer;
        block5: for (int i = 1; i < characters.length; ++i) {
            switch (characters[i]) {
                case '/': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    parsedAddress = WildflyCompatibilityUtils.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
                    keyBuffer = new StringBuilder();
                    valueBuffer = new StringBuilder();
                    currentBuffer = keyBuffer;
                    continue block5;
                }
                case '\\': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    escaped = true;
                    continue block5;
                }
                case '=': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    currentBuffer = valueBuffer;
                    continue block5;
                }
                default: {
                    currentBuffer.append(characters[i]);
                }
            }
        }
        parsedAddress = WildflyCompatibilityUtils.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
        return parsedAddress;
    }

    private static PathAddress addpathAddressElement(PathAddress parsedAddress, String address, StringBuilder keyBuffer, StringBuilder valueBuffer) {
        if (keyBuffer.length() > 0) {
            if (valueBuffer.length() > 0) {
                return parsedAddress.append(PathElement.pathElement(keyBuffer.toString(), valueBuffer.toString()));
            }
            throw new IllegalArgumentException("Illegal path address '" + address + "' , it is not in a correct CLI format");
        }
        return parsedAddress;
    }

    public static class EAP6WrappedSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory wrapped;

        public EAP6WrappedSSLSocketFactory(SSLSocketFactory wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.wrapped.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.wrapped.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            Socket newSocket = this.wrapped.createSocket(socket, s, i, b);
            if (newSocket == null) {
                try {
                    Field innerWrappedField = this.wrapped.getClass().getDeclaredField("wrapped");
                    innerWrappedField.setAccessible(true);
                    SSLSocketFactory innerWrapped = (SSLSocketFactory)innerWrappedField.get(this.wrapped);
                    newSocket = innerWrapped.createSocket(socket, s, i, b);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return newSocket;
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.wrapped.createSocket(s, i);
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.wrapped.createSocket(s, i, inetAddress, i1);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.wrapped.createSocket(inetAddress, i);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.wrapped.createSocket(inetAddress, i, inetAddress1, i1);
        }
    }
}

