/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import java.io.Closeable;
import java.io.IOException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;

public class ConnectionContext
implements Closeable {
    private Connection connection;
    private Session session;
    private Destination destination;

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void copy(ConnectionContext source) {
        this.connection = source.connection;
        this.session = source.session;
        this.destination = source.destination;
    }

    @Override
    public void close() throws IOException {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                throw new IOException(e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                throw new IOException(e);
            }
        }
    }
}

