/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common.consumer;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class BytesMessageInputStream
extends InputStream {
    private final BytesMessage delegate;

    public BytesMessageInputStream(BytesMessage delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.delegate.readByte();
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return this.delegate.readBytes(b);
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off == 0) {
            try {
                return this.delegate.readBytes(b, len);
            }
            catch (JMSException e) {
                throw new IOException(e);
            }
        }
        return super.read(b, off, len);
    }
}

