/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmr.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.Property;

public class DmrNodePath {
    public static final String ANY_NAME = "*";
    private static final DmrNodePath ROOT_PATH = new DmrNodePath(Collections.emptyList());
    private final List<DmrNodePathSegment> segments;

    public static DmrNodePath absolutize(DmrNodePath base, DmrNodePath relativePath) {
        if (base == null) {
            return relativePath;
        }
        return DmrNodePath.builder().segments(base).segments(relativePath).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DmrNodePath rootPath() {
        return ROOT_PATH;
    }

    private DmrNodePath(List<DmrNodePathSegment> segments) {
        this.segments = segments;
    }

    public ModelNode asModelNode() {
        ModelNode result = new ModelNode();
        for (DmrNodePathSegment segment : this.segments) {
            result.add(segment.getType(), segment.getName());
        }
        result.protect();
        return result;
    }

    public DmrNodePathSegment getLastSegment() {
        if (this.segments.isEmpty()) {
            throw new IndexOutOfBoundsException("There is no last segment in an empty [" + this.getClass().getName() + "]");
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public List<DmrNodePathSegment> getSegments() {
        return this.segments;
    }

    public boolean isParentOf(DmrNodePath other) {
        if (this.segments.size() <= other.segments.size()) {
            for (int i = 0; i < this.segments.size(); ++i) {
                if (this.segments.get(i).matches(other.segments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(DmrNodePath other) {
        if (this.segments.size() == other.segments.size()) {
            for (int i = 0; i < this.segments.size(); ++i) {
                if (this.segments.get(i).matches(other.segments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (DmrNodePathSegment segment : this.segments) {
            result.append('/').append(segment.getType()).append('=').append(segment.getName());
        }
        return result.toString();
    }

    public static class DmrNodePathSegment {
        private final String name;
        private final String type;

        private DmrNodePathSegment(String type, String name) {
            if (type == null) {
                throw new IllegalArgumentException("Cannot create a " + this.getClass().getName() + " with a null type.");
            }
            if (name == null) {
                throw new IllegalArgumentException("Cannot create a " + this.getClass().getName() + " with a null type.");
            }
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmrNodePathSegment other = (DmrNodePathSegment)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean matches(DmrNodePathSegment other) {
            return this.type.equals(other.type) && (this.name.equals(other.name) || this.name.equals(DmrNodePath.ANY_NAME));
        }

        public String toString() {
            return this.type + "=" + this.name;
        }
    }

    public static class Builder {
        private List<DmrNodePathSegment> segments = new ArrayList<DmrNodePathSegment>();

        public Builder any(String type) {
            this.segments.add(new DmrNodePathSegment(type, DmrNodePath.ANY_NAME));
            return this;
        }

        public DmrNodePath build() {
            return new DmrNodePath(Collections.unmodifiableList(this.segments));
        }

        public Builder segment(String type, String name) {
            this.segments.add(new DmrNodePathSegment(type, name));
            return this;
        }

        public Builder segments(DmrNodePath path) {
            this.segments.addAll(path.getSegments());
            return this;
        }

        public Builder segments(List<DmrNodePathSegment> segmentsToAdd, int start, int end) {
            for (int i = start; i < end; ++i) {
                this.segments.add(segmentsToAdd.get(i));
            }
            return this;
        }

        public Builder segments(ModelNode address) {
            for (Property prop : address.asPropertyList()) {
                this.segment(prop.getName(), prop.getValue().asString());
            }
            return this;
        }

        public Builder segments(String path) {
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int eqPos = token.indexOf(61);
                if (eqPos >= 0) {
                    String key = token.substring(0, eqPos);
                    String value = token.substring(eqPos + 1);
                    this.segment(key, value);
                    continue;
                }
                this.segment(token, DmrNodePath.ANY_NAME);
            }
            return this;
        }
    }
}

