/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.util.Arrays;
import java.util.List;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.Property;

public class Address
implements Cloneable {
    private ModelNode addressNode = new ModelNode();

    public static Address root() {
        return new Address();
    }

    public static Address parse(String addressStr) {
        String[] resources;
        Address address = Address.root();
        if (addressStr == null) {
            return address;
        }
        if ((addressStr = addressStr.trim()).isEmpty()) {
            return address;
        }
        for (String resource : resources = addressStr.split("/")) {
            if ((resource = resource.trim()).isEmpty()) continue;
            String[] typeAndName = resource.split("=");
            String type = typeAndName[0].trim();
            String name = typeAndName.length == 2 ? typeAndName[1].trim() : "";
            address.add(type, name);
        }
        return address;
    }

    public static Address fromModelNode(ModelNode node) {
        Address address = Address.root();
        if (!node.isDefined()) {
            return address;
        }
        try {
            List<Property> addressList = node.asPropertyList();
            for (Property addressProperty : addressList) {
                String resourceType = addressProperty.getName();
                String resourceName = addressProperty.getValue().asString();
                address.add(resourceType, resourceName);
            }
            return address;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Node cannot be used as an address: " + node.toJSONString(true));
        }
    }

    public static Address fromModelNodeWrapper(ModelNode haystack, String needle) {
        if (haystack.hasDefined(needle)) {
            return Address.fromModelNode(haystack.get(needle));
        }
        throw new IllegalArgumentException("There is no address under the key [" + needle + "] in the node: " + haystack.toJSONString(true));
    }

    public Address() {
    }

    public Address(String ... addressParts) {
        this();
        this.add(addressParts);
    }

    public ModelNode getAddressNode() {
        return this.addressNode;
    }

    public Address add(String ... addressParts) {
        if (addressParts != null) {
            if (addressParts.length % 2 != 0) {
                throw new IllegalArgumentException("address is incomplete: " + Arrays.toString(addressParts));
            }
            if (addressParts.length > 0) {
                for (int i = 0; i < addressParts.length; i += 2) {
                    this.addressNode.add(addressParts[i], addressParts[i + 1]);
                }
            }
        }
        return this;
    }

    public Address add(String type, String name) {
        this.addressNode.add(type, name);
        return this;
    }

    public Address add(Address address) {
        if (address == null || address.isRoot()) {
            return this;
        }
        if (this.isRoot()) {
            this.addressNode = address.addressNode.clone();
        } else {
            List<Property> parts = address.addressNode.asPropertyList();
            for (Property part : parts) {
                this.addressNode.add(part);
            }
        }
        return this;
    }

    public boolean isRoot() {
        return !this.addressNode.isDefined();
    }

    public String[] toAddressParts() {
        if (this.isRoot()) {
            return new String[0];
        }
        List<Property> properties = this.addressNode.asPropertyList();
        String[] parts = new String[properties.size() * 2];
        int i = 0;
        for (Property property : properties) {
            String name = property.getName();
            String value = property.getValue().asString();
            parts[i++] = name;
            parts[i++] = value;
        }
        return parts;
    }

    public String toAddressPathString() {
        if (this.isRoot()) {
            return "/";
        }
        StringBuilder str = new StringBuilder();
        List<Property> parts = this.addressNode.asPropertyList();
        for (Property part : parts) {
            String name = part.getName();
            String value = part.getValue().asString();
            str.append("/").append(name).append("=").append(value);
        }
        return str.toString();
    }

    public Address clone() {
        Address clone = new Address();
        clone.addressNode = this.addressNode.clone();
        return clone;
    }

    public String toString() {
        return this.toAddressPathString();
    }

    public int hashCode() {
        return this.addressNode.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        return this.addressNode.equals(((Address)obj).addressNode);
    }
}

