/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.wildfly.plugin.core.Deployment;
import org.shaded.wildfly.plugin.core.DeploymentManager;
import org.shaded.wildfly.plugin.core.DeploymentResult;
import org.shaded.wildfly.plugin.core.SimpleDeploymentDescription;
import org.shaded.wildfly.plugin.core.UndeployDescription;

public class DeploymentJBossASClient
extends JBossASClient {
    public DeploymentJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public void enableDeployment(String name, Set<String> serverGroups) throws Exception {
        this.enableDisableDeployment(name, true, serverGroups);
    }

    public void disableDeployment(String name, Set<String> serverGroups) throws Exception {
        this.enableDisableDeployment(name, false, serverGroups);
    }

    private void enableDisableDeployment(String name, boolean enable, Set<String> serverGroups) throws Exception {
        DeploymentResult result;
        if (serverGroups == null) {
            serverGroups = Collections.emptySet();
        }
        DeploymentManager dm = DeploymentManager.Factory.create(this.getModelControllerClient());
        if (enable) {
            SimpleDeploymentDescription sdd = SimpleDeploymentDescription.of(name);
            sdd.addServerGroups(serverGroups);
            result = dm.deployToRuntime(sdd);
        } else {
            UndeployDescription ud = UndeployDescription.of(name);
            ud.addServerGroups(serverGroups);
            ud.setRemoveContent(false);
            result = dm.undeploy(ud);
        }
        if (!result.successful()) {
            throw new FailureException(result.getFailureMessage());
        }
    }

    public void restartDeployment(String name, Set<String> serverGroups) throws Exception {
        if (serverGroups == null) {
            serverGroups = Collections.emptySet();
        }
        DeploymentManager dm = DeploymentManager.Factory.create(this.getModelControllerClient());
        SimpleDeploymentDescription sdd = SimpleDeploymentDescription.of(name);
        sdd.addServerGroups(serverGroups);
        DeploymentResult result = dm.redeployToRuntime(sdd);
        if (!result.successful()) {
            throw new FailureException(result.getFailureMessage());
        }
    }

    public void deploy(String deploymentName, InputStream content, boolean enabled, Set<String> serverGroups, boolean forceDeploy) {
        if (serverGroups == null) {
            serverGroups = Collections.emptySet();
        }
        DeploymentResult result = null;
        try {
            DeploymentManager dm = DeploymentManager.Factory.create(this.getModelControllerClient());
            Deployment deployment = Deployment.of(content, deploymentName).addServerGroups(serverGroups).setEnabled(enabled);
            result = forceDeploy ? dm.forceDeploy(deployment) : dm.deploy(deployment);
        }
        catch (Exception e) {
            String errMsg = serverGroups.isEmpty() ? String.format("Failed to deploy [%s] (standalone mode)", deploymentName) : String.format("Failed to deploy [%s] to server groups: %s", deploymentName, serverGroups);
            throw new FailureException(errMsg, (Throwable)e);
        }
        if (!result.successful()) {
            String errMsg = serverGroups.isEmpty() ? String.format("Failed to deploy [%s] (standalone mode)", deploymentName) : String.format("Failed to deploy [%s] to server groups [%s]", deploymentName, serverGroups);
            throw new FailureException(errMsg + ": " + result.getFailureMessage());
        }
    }

    public void undeploy(String deploymentName, Set<String> serverGroups, boolean removeContent) {
        if (serverGroups == null) {
            serverGroups = Collections.emptySet();
        }
        DeploymentResult result = null;
        try {
            DeploymentManager dm = DeploymentManager.Factory.create(this.getModelControllerClient());
            UndeployDescription undeployDescription = UndeployDescription.of(deploymentName).addServerGroups(serverGroups).setFailOnMissing(false).setRemoveContent(removeContent);
            result = dm.undeploy(undeployDescription);
        }
        catch (Exception e) {
            String errMsg = serverGroups.isEmpty() ? String.format("Failed to undeploy [%s] (standalone mode)", deploymentName) : String.format("Failed to undeploy [%s] from server groups: %s", deploymentName, serverGroups);
            throw new FailureException(errMsg, (Throwable)e);
        }
        if (!result.successful()) {
            String errMsg = serverGroups.isEmpty() ? String.format("Failed to undeploy [%s] (standalone mode)", deploymentName) : String.format("Failed to undeploy [%s] from server groups [%s]", deploymentName, serverGroups);
            throw new FailureException(errMsg + ": " + result.getFailureMessage());
        }
    }
}

