/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.JBossASClient;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.dmr.ModelNode;

public class InfinispanJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_INFINISPAN = "infinispan";
    public static final String CACHE_CONTAINER = "cache-container";
    public static final String LOCAL_CACHE = "local-cache";

    public InfinispanJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isCacheContainer(String cacheContainerName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN);
        return null != this.findNodeInList(addr, haystack = CACHE_CONTAINER, cacheContainerName);
    }

    public boolean isLocalCache(String cacheContainerName, String localCacheName) throws Exception {
        String haystack;
        if (!this.isCacheContainer(cacheContainerName)) {
            return false;
        }
        Address addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, cacheContainerName);
        return null != this.findNodeInList(addr, haystack = LOCAL_CACHE, localCacheName);
    }

    public ModelNode createNewCacheContainerRequest(String name, String defaultCacheName) {
        String dmrTemplate = "{\"default-cache-name\" => \"%s\" ,\"jndi-name\" => \"%s\" }";
        String jndiName = "java:jboss/infinispan/" + name;
        String dmr = String.format(dmrTemplate, defaultCacheName, jndiName);
        Address addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, name);
        ModelNode result = ModelNode.fromString(dmr);
        result.get("operation").set("add");
        result.get("address").set(addr.getAddressNode());
        return result;
    }

    public ModelNode createNewLocalCacheRequest(String cacheContainerName, String localCacheName, String transactionMode, String evictionStrategy, Long evictionMaxEntries, Long expirationLifeSpan, Long expirationMaxIdle, String isolationLevel) throws Exception {
        if (!this.isCacheContainer(cacheContainerName)) {
            throw new IllegalArgumentException("cache-container does not exist [" + cacheContainerName + "]");
        }
        ModelNode[] result = new ModelNode[4];
        Address addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, cacheContainerName, LOCAL_CACHE, localCacheName);
        String dmrTemplate = "{\"isolation-level\" =>  \"%s\" }";
        String dmr = String.format(dmrTemplate, null == isolationLevel ? "REPEATABLE_READ" : isolationLevel);
        result[0] = ModelNode.fromString(dmr);
        result[0].get("operation").set("add");
        result[0].get("address").set(addr.getAddressNode());
        addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, cacheContainerName, LOCAL_CACHE, localCacheName, "eviction", "EVICTION");
        dmrTemplate = "{\"strategy\" =>  \"%s\" ,\"max-entries\" =>  %dL }";
        dmr = String.format(dmrTemplate, null == evictionStrategy ? "LRU" : evictionStrategy, null == evictionMaxEntries ? 50000L : evictionMaxEntries);
        result[1] = ModelNode.fromString(dmr);
        result[1].get("operation").set("add");
        result[1].get("address").set(addr.getAddressNode());
        addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, cacheContainerName, LOCAL_CACHE, localCacheName, "expiration", "EXPIRATION");
        dmrTemplate = "{\"max-idle\" =>  %dL ,\"lifespan\" =>  %dL }";
        dmr = String.format(dmrTemplate, null == expirationMaxIdle ? 100000L : expirationMaxIdle, null == expirationLifeSpan ? -1L : expirationLifeSpan);
        result[2] = ModelNode.fromString(dmr);
        result[2].get("operation").set("add");
        result[2].get("address").set(addr.getAddressNode());
        addr = Address.root().add("subsystem", SUBSYSTEM_INFINISPAN, CACHE_CONTAINER, cacheContainerName, LOCAL_CACHE, localCacheName, "transaction", "TRANSACTION");
        dmrTemplate = "{\"mode\" => \"%s\" }";
        dmr = String.format(dmrTemplate, null == transactionMode ? "NONE" : transactionMode);
        result[3] = ModelNode.fromString(dmr);
        result[3].get("operation").set("add");
        result[3].get("address").set(addr.getAddressNode());
        return InfinispanJBossASClient.createBatchRequest(result);
    }
}

