/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.dmr.ModelNode;

public class LoggingJBossASClient
extends JBossASClient {
    public static final String LOGGING = "logging";
    public static final String LOGGER = "logger";
    public static final String FILE_HANDLER = "periodic-rotating-file-handler";

    public LoggingJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isLogger(String loggerName) throws Exception {
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        return null != this.readResource(addr);
    }

    public String getLoggerLevel(String loggerName) throws Exception {
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        return this.getStringAttribute("level", addr);
    }

    public void setLoggerLevel(String loggerName, String level) throws Exception {
        ModelNode request;
        Address addr = Address.root().add("subsystem", LOGGING, LOGGER, loggerName);
        if (this.isLogger(loggerName)) {
            request = LoggingJBossASClient.createWriteAttributeRequest("level", level, addr);
        } else {
            String dmrTemplate = "{\"category\" => \"%s\" , \"level\" => \"%s\" , \"use-parent-handlers\" => \"true\" }";
            String dmr = String.format("{\"category\" => \"%s\" , \"level\" => \"%s\" , \"use-parent-handlers\" => \"true\" }", loggerName, level);
            request = ModelNode.fromString(dmr);
            request.get("operation").set("add");
            request.get("address").set(addr.getAddressNode());
        }
        ModelNode response = this.execute(request);
        if (!LoggingJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public void setFilterSpec(String filterSpec) throws Exception {
        Address addr = Address.root().add("subsystem", LOGGING, FILE_HANDLER, "FILE");
        ModelNode request = LoggingJBossASClient.createWriteAttributeRequest("filter-spec", filterSpec, addr);
        ModelNode response = this.execute(request);
        if (!LoggingJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }
}

