/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.FailureException;
import org.hawkular.dmrclient.JBossASClient;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.dmr.ModelNode;

public class WebJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_WEB = "web";
    public static final String VIRTUAL_SERVER = "virtual-server";
    public static final String DEFAULT_HOST = "default-host";
    public static final String CONNECTOR = "connector";
    public static final String SSL = "ssl";

    public WebJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isWebSubsystem() throws Exception {
        Address addr = Address.root().add("subsystem", SUBSYSTEM_WEB);
        return null != this.readResource(addr);
    }

    public void setEnableWelcomeRoot(boolean enableFlag) throws Exception {
        Address address = Address.root().add("subsystem", SUBSYSTEM_WEB, VIRTUAL_SERVER, DEFAULT_HOST);
        ModelNode req = WebJBossASClient.createWriteAttributeRequest("enable-welcome-root", Boolean.toString(enableFlag), address);
        ModelNode response = this.execute(req);
        if (!WebJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public boolean isConnector(String name) throws Exception {
        Address address = Address.root().add("subsystem", SUBSYSTEM_WEB, CONNECTOR, name);
        return null != this.readResource(address);
    }

    public ModelNode getConnector(String name) throws Exception {
        Address address = Address.root().add("subsystem", SUBSYSTEM_WEB, CONNECTOR, name);
        return this.readResource(address, true);
    }

    public void changeConnector(String connectorName, String attribName, String attribValue) throws Exception {
        Address address = Address.root().add("subsystem", SUBSYSTEM_WEB, CONNECTOR, connectorName);
        ModelNode op = WebJBossASClient.createWriteAttributeRequest(attribName, attribValue, address);
        ModelNode response = this.execute(op);
        if (!WebJBossASClient.isSuccess(response)) {
            throw new FailureException(response);
        }
    }

    public void removeConnector(String doomedConnectorName) throws Exception {
        Address address = Address.root().add("subsystem", SUBSYSTEM_WEB, CONNECTOR, doomedConnectorName);
        if (this.isConnector(doomedConnectorName)) {
            this.remove(address);
        }
    }

    public void addConnector(String name, ConnectorConfiguration connectorConfig) throws Exception {
        ModelNode fullRequest;
        Address connectorAddress = Address.root().add("subsystem", SUBSYSTEM_WEB, CONNECTOR, name);
        ModelNode connectorRequest = WebJBossASClient.createRequest("add", connectorAddress);
        WebJBossASClient.setPossibleExpression(connectorRequest, "executor", connectorConfig.getExecutor());
        WebJBossASClient.setPossibleExpression(connectorRequest, "max-connections", connectorConfig.getMaxConnections());
        WebJBossASClient.setPossibleExpression(connectorRequest, "max-post-size", connectorConfig.getMaxPostSize());
        WebJBossASClient.setPossibleExpression(connectorRequest, "max-save-post-size", connectorConfig.getMaxSavePostSize());
        WebJBossASClient.setPossibleExpression(connectorRequest, "protocol", connectorConfig.getProtocol());
        WebJBossASClient.setPossibleExpression(connectorRequest, "proxy-name", connectorConfig.getProxyName());
        WebJBossASClient.setPossibleExpression(connectorRequest, "proxy-port", connectorConfig.getProxyPort());
        WebJBossASClient.setPossibleExpression(connectorRequest, "scheme", connectorConfig.getScheme());
        WebJBossASClient.setPossibleExpression(connectorRequest, "socket-binding", connectorConfig.getSocketBinding());
        WebJBossASClient.setPossibleExpression(connectorRequest, "redirect-port", connectorConfig.getRedirectPort());
        WebJBossASClient.setPossibleExpression(connectorRequest, "enabled", String.valueOf(connectorConfig.isEnabled()));
        WebJBossASClient.setPossibleExpression(connectorRequest, "enable-lookups", String.valueOf(connectorConfig.isEnableLookups()));
        WebJBossASClient.setPossibleExpression(connectorRequest, "secure", String.valueOf(connectorConfig.isSecure()));
        SSLConfiguration sslConfig = connectorConfig.getSslConfiguration();
        if (sslConfig != null) {
            Address sslAddress = connectorAddress.clone().add(SSL, "configuration");
            ModelNode sslRequest = WebJBossASClient.createRequest("add", sslAddress);
            WebJBossASClient.setPossibleExpression(sslRequest, "ca-certificate-file", sslConfig.getCaCertificateFile());
            WebJBossASClient.setPossibleExpression(sslRequest, "ca-certificate-password", sslConfig.getCaCertificatePassword());
            WebJBossASClient.setPossibleExpression(sslRequest, "ca-revocation-url", sslConfig.getCaRevocationUrl());
            WebJBossASClient.setPossibleExpression(sslRequest, "certificate-file", sslConfig.getCertificateFile());
            WebJBossASClient.setPossibleExpression(sslRequest, "certificate-key-file", sslConfig.getCertificateKeyFile());
            WebJBossASClient.setPossibleExpression(sslRequest, "cipher-suite", sslConfig.getCipherSuite());
            WebJBossASClient.setPossibleExpression(sslRequest, "key-alias", sslConfig.getKeyAlias());
            WebJBossASClient.setPossibleExpression(sslRequest, "keystore-type", sslConfig.getKeystoreType());
            WebJBossASClient.setPossibleExpression(sslRequest, "name", sslConfig.getName());
            WebJBossASClient.setPossibleExpression(sslRequest, "password", sslConfig.getPassword());
            WebJBossASClient.setPossibleExpression(sslRequest, "protocol", sslConfig.getProtocol());
            WebJBossASClient.setPossibleExpression(sslRequest, "session-cache-size", sslConfig.getSessionCacheSize());
            WebJBossASClient.setPossibleExpression(sslRequest, "session-timeout", sslConfig.getSessionTimeout());
            WebJBossASClient.setPossibleExpression(sslRequest, "truststore-type", sslConfig.getTruststoreType());
            WebJBossASClient.setPossibleExpression(sslRequest, "verify-client", sslConfig.getVerifyClient());
            WebJBossASClient.setPossibleExpression(sslRequest, "verify-depth", sslConfig.getVerifyDepth());
            fullRequest = WebJBossASClient.createBatchRequest(connectorRequest, sslRequest);
        } else {
            fullRequest = connectorRequest;
        }
        ModelNode response = this.execute(fullRequest);
        if (!WebJBossASClient.isSuccess(response)) {
            throw new FailureException(response, "Failed to add new connector [" + name + "]");
        }
    }

    public static class SSLConfiguration {
        private String caCertificateFile;
        private String caCertificatePassword;
        private String caRevocationUrl;
        private String certificateKeyFile;
        private String certificateFile;
        private String cipherSuite;
        private String keyAlias;
        private String keystoreType;
        private String name;
        private String password;
        private String protocol = "HTTP/1.1";
        private String sessionCacheSize;
        private String sessionTimeout;
        private String truststoreType;
        private String verifyClient;
        private String verifyDepth;

        public String getCaCertificateFile() {
            return this.caCertificateFile;
        }

        public void setCaCertificateFile(String caCertificateFile) {
            this.caCertificateFile = caCertificateFile;
        }

        public String getCaCertificatePassword() {
            return this.caCertificatePassword;
        }

        public void setCaCertificationPassword(String caCertificatePassword) {
            this.caCertificatePassword = caCertificatePassword;
        }

        public String getCaRevocationUrl() {
            return this.caRevocationUrl;
        }

        public void setCaRevocationUrl(String caRevocationUrl) {
            this.caRevocationUrl = caRevocationUrl;
        }

        public String getCertificateKeyFile() {
            return this.certificateKeyFile;
        }

        public void setCertificateKeyFile(String certificateKeyFile) {
            this.certificateKeyFile = certificateKeyFile;
        }

        public String getCertificateFile() {
            return this.certificateFile;
        }

        public void setCertificateFile(String certificateFile) {
            this.certificateFile = certificateFile;
        }

        public String getCipherSuite() {
            return this.cipherSuite;
        }

        public void setCipherSuite(String cipherSuite) {
            this.cipherSuite = cipherSuite;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public void setKeyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
        }

        public String getKeystoreType() {
            return this.keystoreType;
        }

        public void setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getSessionCacheSize() {
            return this.sessionCacheSize;
        }

        public void setSessionCacheSize(String sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
        }

        public String getSessionTimeout() {
            return this.sessionTimeout;
        }

        public void setSessionTimeout(String sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        public String getTruststoreType() {
            return this.truststoreType;
        }

        public void setTruststoreType(String truststoreType) {
            this.truststoreType = truststoreType;
        }

        public String getVerifyClient() {
            return this.verifyClient;
        }

        public void setVerifyClient(String verifyClient) {
            this.verifyClient = verifyClient;
        }

        public String getVerifyDepth() {
            return this.verifyDepth;
        }

        public void setVerifyDepth(String verifyDepth) {
            this.verifyDepth = verifyDepth;
        }
    }

    public static class ConnectorConfiguration {
        private boolean enabled = true;
        private boolean enableLookups = false;
        private String executor;
        private String maxConnections;
        private String maxSavePostSize;
        private String maxPostSize;
        private String protocol = "HTTP/1.1";
        private String proxyPort;
        private String proxyName;
        private String scheme;
        private boolean secure = false;
        private String socketBinding;
        private String redirectPort;
        private SSLConfiguration sslConfiguration;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnableLookups() {
            return this.enableLookups;
        }

        public void setEnableLookups(boolean enableLookups) {
            this.enableLookups = enableLookups;
        }

        public String getExecutor() {
            return this.executor;
        }

        public void setExecutor(String executor) {
            this.executor = executor;
        }

        public String getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(String maxConnections) {
            this.maxConnections = maxConnections;
        }

        public String getMaxSavePostSize() {
            return this.maxSavePostSize;
        }

        public void setMaxSavePostSize(String maxSavePostSize) {
            this.maxSavePostSize = maxSavePostSize;
        }

        public String getMaxPostSize() {
            return this.maxPostSize;
        }

        public void setMaxPostSize(String maxPostSize) {
            this.maxPostSize = maxPostSize;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProxyPort() {
            return this.proxyPort;
        }

        public void setProxyPort(String proxyPort) {
            this.proxyPort = proxyPort;
        }

        public String getProxyName() {
            return this.proxyName;
        }

        public void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public String getSocketBinding() {
            return this.socketBinding;
        }

        public void setSocketBinding(String socketBinding) {
            this.socketBinding = socketBinding;
        }

        public String getRedirectPort() {
            return this.redirectPort;
        }

        public void setRedirectPort(String redirectPort) {
            this.redirectPort = redirectPort;
        }

        public SSLConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        public void setSslConfiguration(SSLConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            if (sslConfiguration != null) {
                this.secure = true;
            }
        }
    }
}

