/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.shaded.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="Metric type defines the unit and data type of a metric. It also specifies the default  collection interval as a guideline for the feed on how often to collect the metric values.", parent=Entity.class)
public final class MetricType
extends Entity {
    public static final SegmentType SEGMENT_TYPE = SegmentType.mt;
    private final MetricUnit unit;
    private final MetricDataType metricDataType;
    private final Long collectionInterval;

    private MetricType() {
        this.unit = null;
        this.metricDataType = null;
        this.collectionInterval = null;
    }

    public MetricType(CanonicalPath path) {
        this(path, MetricUnit.NONE, MetricDataType.GAUGE, null, null);
    }

    public MetricType(CanonicalPath path, MetricUnit unit, MetricDataType metricDataType) {
        this(path, unit, metricDataType, null, null);
    }

    public MetricType(CanonicalPath path, MetricUnit unit, MetricDataType metricDataType, Long collectionInterval) {
        this(path, unit, metricDataType, null, collectionInterval);
    }

    public MetricType(String name, CanonicalPath path, MetricUnit unit, MetricDataType metricDataType) {
        this(name, path, unit, metricDataType, null, null);
    }

    public MetricType(CanonicalPath path, MetricUnit unit, MetricDataType metricDataType, Map<String, Object> properties, Long collectionInterval) {
        super(null, path, properties);
        if (metricDataType == null) {
            throw new IllegalArgumentException("metricDataType == null");
        }
        this.unit = unit;
        this.metricDataType = metricDataType;
        this.collectionInterval = collectionInterval;
    }

    public MetricType(String name, CanonicalPath path, MetricUnit unit, MetricDataType metricDataType, Map<String, Object> properties, Long collectionInterval) {
        super(name, path, properties);
        this.metricDataType = metricDataType;
        this.unit = unit;
        this.collectionInterval = collectionInterval;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public MetricDataType getMetricDataType() {
        return this.metricDataType;
    }

    @Deprecated
    @JsonSerialize(using=ToStringSerializer.class)
    public MetricDataType getType() {
        return this.getMetricDataType();
    }

    public Long getCollectionInterval() {
        return this.collectionInterval;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetricType(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", unit=").append((Object)this.unit);
    }

    @ApiModel(value="MetricTypeBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        private final MetricUnit unit;
        private final MetricDataType metricDataType;
        private final Long collectionInterval;

        public static Builder builder(MetricDataType type) {
            return new Builder(type);
        }

        private Blueprint() {
            this.unit = null;
            this.metricDataType = null;
            this.collectionInterval = null;
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType metricDataType, Long collectionInterval) {
            this(id, unit, metricDataType, Collections.emptyMap(), collectionInterval);
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType metricDataType, Map<String, Object> properties, Long collectionInterval) {
            super(id, properties);
            this.unit = unit == null ? MetricUnit.NONE : unit;
            this.metricDataType = metricDataType;
            this.collectionInterval = collectionInterval;
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType metricDataType, Long collectionInterval, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.metricDataType = metricDataType;
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public Blueprint(String id, String name, MetricUnit unit, MetricDataType metricDataType, Map<String, Object> properties, Long collectionInterval, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
            this.metricDataType = metricDataType;
            this.unit = unit;
            this.collectionInterval = collectionInterval;
        }

        public MetricUnit getUnit() {
            if (this.unit == null) {
                throw new IllegalStateException("Unit of metric type cannot be null.");
            }
            return this.unit;
        }

        public MetricDataType getMetricDataType() {
            if (this.metricDataType == null) {
                throw new IllegalStateException("Data type of metric type cannot be null.");
            }
            return this.metricDataType;
        }

        @Deprecated
        @JsonSerialize(using=ToStringSerializer.class)
        public MetricDataType getType() {
            return this.getMetricDataType();
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetricType(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private MetricUnit unit;
            private MetricDataType metricDataType;
            private Long collectionInterval;

            public Builder(MetricDataType metricDataType) {
                this.metricDataType = metricDataType;
            }

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            @Deprecated
            public Builder withType(MetricDataType type) {
                this.metricDataType = type;
                return this;
            }

            public Builder withInterval(Long interval) {
                this.collectionInterval = interval;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.unit, this.metricDataType, this.properties, this.collectionInterval, this.outgoing, this.incoming);
            }
        }
    }
}

