/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.shaded.fasterxml.jackson.core.JsonGenerator;
import com.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.shaded.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.hawkular.inventory.api.model.StructuredData;

public final class StructuredDataSerializer
extends JsonSerializer<StructuredData> {
    @Override
    public void serialize(StructuredData value, final JsonGenerator jgen, SerializerProvider provider) throws IOException {
        value.accept(new StructuredData.Visitor.Simple<Void, Void>(){

            @Override
            public Void visitBool(boolean value, Void parameter) {
                try {
                    jgen.writeBoolean(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            @Override
            public Void visitIntegral(long value, Void parameter) {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            @Override
            public Void visitFloatingPoint(double value, Void parameter) {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            @Override
            public Void visitString(String value, Void parameter) {
                try {
                    jgen.writeString(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            @Override
            public Void visitUndefined(Void parameter) {
                try {
                    jgen.writeNull();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write value of structured data.", e);
                }
                return null;
            }

            @Override
            public Void visitList(List<StructuredData> value, Void parameter) {
                try {
                    jgen.writeStartArray();
                    for (StructuredData m : value) {
                        m.accept(this, null);
                    }
                    jgen.writeEndArray();
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write structured data.", e);
                }
            }

            @Override
            public Void visitMap(Map<String, StructuredData> value, Void parameter) {
                try {
                    jgen.writeStartObject();
                    for (Map.Entry<String, StructuredData> e : value.entrySet()) {
                        jgen.writeFieldName(e.getKey());
                        e.getValue().accept(this, null);
                    }
                    jgen.writeEndObject();
                    return null;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to write structured data.", e);
                }
            }
        }, null);
    }
}

