/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.client.common.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.hawkular.metrics.client.common.http.HawkularHttpClient;
import org.hawkular.metrics.client.common.http.HawkularHttpResponse;
import org.shaded.slf4j.Logger;
import org.shaded.slf4j.LoggerFactory;

public class JdkHawkularHttpClient
implements HawkularHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(JdkHawkularHttpClient.class);
    private final String uri;
    private final Map<String, String> headers = new HashMap<String, String>();
    private Optional<Long> failoverCacheDuration = Optional.empty();
    private Optional<Integer> failoverCacheMaxSize = Optional.empty();
    private Queue<Message> failoverCache = new LinkedBlockingQueue<Message>();

    public JdkHawkularHttpClient(String uri) {
        this.uri = uri + "/hawkular/metrics";
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    public HawkularHttpResponse postMetrics(String jsonBody) {
        return this.buildURLAndSend("POST", "/metrics/raw", jsonBody.getBytes());
    }

    @Override
    public HawkularHttpResponse putTags(String metricType, String metricName, String jsonBody) {
        try {
            String encodedFullName = URLEncoder.encode(metricName, "UTF-8");
            String resourcePath = "/" + metricType + "/" + encodedFullName + "/tags";
            return this.buildURLAndSend("PUT", resourcePath, jsonBody.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            return new HawkularHttpResponse("", -1, "Message not sent, unsupported encoding: " + e.getMessage());
        }
    }

    public HawkularHttpResponse readMetric(String type, String name) throws IOException {
        URL url = new URL(this.uri + "/" + type + "/" + name + "/raw");
        return this.get(url);
    }

    private HawkularHttpResponse buildURLAndSend(String verb, String resourcePath, byte[] content) {
        URL url;
        try {
            url = new URL(this.uri + resourcePath);
        }
        catch (MalformedURLException e) {
            LOG.error("Bad URL", e);
            return new HawkularHttpResponse("", -1, "Message not sent, bad URL: " + e.getMessage());
        }
        return this.sendAndHandleError(new Message(verb, url, content));
    }

    private HawkularHttpResponse sendAndHandleError(Message msg) {
        try {
            HawkularHttpResponse response = this.send(msg);
            int code = response.getResponseCode();
            if (code >= 400) {
                LOG.debug("Server response: {}, {}", (Object)code, (Object)response.getErrorMsg());
                this.addToFailoverCache(msg);
            } else if (code != 200 && code != 204) {
                LOG.debug("Server response: {}, {}", (Object)code, (Object)response.getErrorMsg());
            }
            return response;
        }
        catch (IOException e) {
            LOG.debug("Failed to send data:", e);
            this.addToFailoverCache(msg);
            return new HawkularHttpResponse("", -1, "Message not sent: " + e.getMessage());
        }
    }

    private HawkularHttpResponse send(Message message) throws IOException {
        InputStream is = null;
        byte[] data = null;
        int responseCode = -1;
        ByteArrayOutputStream baos = null;
        try {
            int n;
            HttpURLConnection connection = (HttpURLConnection)message.getUrl().openConnection();
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod(message.getVerb());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", String.valueOf(message.getContent().length));
            this.headers.forEach(connection::setRequestProperty);
            OutputStream os = connection.getOutputStream();
            os.write(message.getContent());
            os.close();
            responseCode = connection.getResponseCode();
            is = connection.getInputStream();
            byte[] buffer = new byte[2048];
            baos = new ByteArrayOutputStream();
            while ((n = is.read(buffer)) >= 0) {
                baos.write(buffer, 0, n);
            }
            data = baos.toByteArray();
        }
        catch (IOException e) {
            if (responseCode > 0) {
                HawkularHttpResponse hawkularHttpResponse = new HawkularHttpResponse("", responseCode, e.getMessage());
                return hawkularHttpResponse;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return new HawkularHttpResponse(new String(data), responseCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HawkularHttpResponse get(URL url) throws IOException {
        int responseCode;
        InputStream is = null;
        byte[] data = null;
        ByteArrayOutputStream baos = null;
        try {
            int n;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            this.headers.forEach(connection::setRequestProperty);
            responseCode = connection.getResponseCode();
            is = connection.getInputStream();
            byte[] buffer = new byte[2048];
            baos = new ByteArrayOutputStream();
            while ((n = is.read(buffer)) >= 0) {
                baos.write(buffer, 0, n);
            }
            data = baos.toByteArray();
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return new HawkularHttpResponse(new String(data), responseCode);
    }

    @Override
    public void setFailoverOptions(Optional<Long> failoverCacheDuration, Optional<Integer> failoverCacheMaxSize) {
        this.failoverCacheDuration = failoverCacheDuration;
        this.failoverCacheMaxSize = failoverCacheMaxSize;
    }

    @Override
    public void manageFailover() {
        Long oldestAllowed = this.failoverCacheDuration.map(d -> System.currentTimeMillis() - d).orElse(0L);
        int size = this.failoverCache.size();
        int countTrashed = 0;
        for (int i = 0; i < size; ++i) {
            Message msg = this.failoverCache.poll();
            if (msg.getTimestamp() >= oldestAllowed) {
                this.sendAndHandleError(msg);
                continue;
            }
            ++countTrashed;
        }
        if (countTrashed > 0) {
            LOG.warn("Failover cache contained {} old items that have been trashed", (Object)countTrashed);
        }
    }

    private void addToFailoverCache(Message msg) {
        this.failoverCacheMaxSize.ifPresent(max -> {
            int size = this.failoverCache.size();
            if (size >= max) {
                LOG.warn("Failover cache reached its maximum capacity ({} requests). Oldest elements will be lost.", max);
            }
            while (size >= max) {
                this.failoverCache.poll();
                --size;
            }
        });
        if (this.failoverCache.isEmpty()) {
            LOG.info("Failed to send data to Hawkular. Data is kept in memory and will be sent again later. More info on DEBUG logs.");
        }
        this.failoverCache.offer(msg);
    }

    public int getFailoverCacheSize() {
        return this.failoverCache.size();
    }

    private static class Message {
        private final String verb;
        private final URL url;
        private final byte[] content;
        private final long timestamp;

        private Message(String verb, URL url, byte[] content) {
            this.verb = verb;
            this.url = url;
            this.content = content;
            this.timestamp = System.currentTimeMillis();
        }

        String getVerb() {
            return this.verb;
        }

        URL getUrl() {
            return this.url;
        }

        byte[] getContent() {
            return this.content;
        }

        Long getTimestamp() {
            return this.timestamp;
        }
    }
}

