/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.client.fluent;

import java.io.IOException;
import org.shaded.apache.http.HttpEntity;
import org.shaded.apache.http.HttpResponse;
import org.shaded.apache.http.StatusLine;
import org.shaded.apache.http.client.ClientProtocolException;
import org.shaded.apache.http.client.HttpResponseException;
import org.shaded.apache.http.client.ResponseHandler;
import org.shaded.apache.http.client.fluent.Content;
import org.shaded.apache.http.entity.ContentType;
import org.shaded.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContentResponseHandler
implements ResponseHandler<Content> {
    ContentResponseHandler() {
    }

    @Override
    public Content handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        if (entity != null) {
            return new Content(EntityUtils.toByteArray(entity), ContentType.getOrDefault(entity));
        }
        return Content.NO_CONTENT;
    }
}

