/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.io.IOException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.shaded.jboss.as.controller.BootContext;
import org.shaded.jboss.as.controller.BootErrorCollector;
import org.shaded.jboss.as.controller.CapabilityRegistry;
import org.shaded.jboss.as.controller.ContainerStateMonitor;
import org.shaded.jboss.as.controller.ControlledProcessState;
import org.shaded.jboss.as.controller.ExpressionResolver;
import org.shaded.jboss.as.controller.ManagementModel;
import org.shaded.jboss.as.controller.ModelController;
import org.shaded.jboss.as.controller.ModelControllerImpl;
import org.shaded.jboss.as.controller.ModelControllerServiceInitialization;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationContextImpl;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.ProcessType;
import org.shaded.jboss.as.controller.ResourceDefinition;
import org.shaded.jboss.as.controller.RunningModeControl;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.shaded.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.shaded.jboss.as.controller.audit.AuditLogger;
import org.shaded.jboss.as.controller.audit.ManagedAuditLogger;
import org.shaded.jboss.as.controller.client.Operation;
import org.shaded.jboss.as.controller.client.OperationAttachments;
import org.shaded.jboss.as.controller.client.OperationMessageHandler;
import org.shaded.jboss.as.controller.client.OperationResponse;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;
import org.shaded.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.notification.NotificationSupport;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersister;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.msc.service.Service;
import org.shaded.jboss.msc.service.ServiceContainer;
import org.shaded.jboss.msc.service.ServiceController;
import org.shaded.jboss.msc.service.ServiceTarget;
import org.shaded.jboss.msc.service.StartContext;
import org.shaded.jboss.msc.service.StartException;
import org.shaded.jboss.msc.service.StopContext;
import org.shaded.jboss.msc.value.InjectedValue;
import org.shaded.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractControllerService
implements Service<ModelController> {
    public static final String BOOT_STACK_SIZE_PROPERTY = "jboss.boot.thread.stack.size";
    public static final int DEFAULT_BOOT_STACK_SIZE = 0x200000;
    private static final OperationDefinition INIT_CONTROLLER_OP = new SimpleOperationDefinitionBuilder("boottime-controller-initializer-step", null).setPrivateEntry().build();
    protected final ProcessType processType;
    protected final DelegatingConfigurableAuthorizer authorizer;
    private final RunningModeControl runningModeControl;
    private final ResourceDefinition rootResourceDefinition;
    private final ControlledProcessState processState;
    private final OperationStepHandler prepareStep;
    private final InjectedValue<ExecutorService> injectedExecutorService = new InjectedValue();
    private final ExpressionResolver expressionResolver;
    private volatile ModelControllerImpl controller;
    private ConfigurationPersister configurationPersister;
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final CapabilityRegistry capabilityRegistry;

    private static int getBootStackSize() {
        String prop = WildFlySecurityManager.getPropertyPrivileged(BOOT_STACK_SIZE_PROPERTY, null);
        if (prop == null) {
            return 0x200000;
        }
        int base = 1;
        String multiple = prop;
        int lastIdx = prop.length() - 1;
        if (lastIdx > 0) {
            char last = prop.charAt(lastIdx);
            if ('k' == last || 'K' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 1024;
            } else if ('m' == last || 'M' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 0x100000;
            }
        }
        try {
            return Integer.parseInt(multiple) * base;
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidSystemPropertyValue(prop, BOOT_STACK_SIZE_PROPERTY, 0x200000);
            return 0x200000;
        }
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        this(processType, runningModeControl, configurationPersister, processState, null, rootDescriptionProvider, prepareStep, expressionResolver, auditLogger, authorizer, new CapabilityRegistry(processType.isServer()));
    }

    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, CapabilityRegistry capabilityRegistry) {
        this(processType, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer, capabilityRegistry);
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this(processType, runningModeControl, configurationPersister, processState, null, rootDescriptionProvider, prepareStep, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new CapabilityRegistry(processType.isServer()));
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this(processType, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer(), new CapabilityRegistry(processType.isServer()));
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        this(processType, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer, new CapabilityRegistry(processType.isServer()));
    }

    private AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer, CapabilityRegistry capabilityRegistry) {
        assert (rootDescriptionProvider == null) : "description provider cannot be used anymore";
        assert (rootResourceDefinition != null) : "Null root resource definition";
        assert (expressionResolver != null) : "Null expressionResolver";
        assert (auditLogger != null) : "Null auditLogger";
        assert (authorizer != null) : "Null authorizer";
        assert (capabilityRegistry != null) : "Null capabilityRegistry";
        this.processType = processType;
        this.runningModeControl = runningModeControl;
        this.configurationPersister = configurationPersister;
        this.rootResourceDefinition = rootResourceDefinition;
        this.processState = processState;
        this.prepareStep = prepareStep;
        this.expressionResolver = expressionResolver;
        this.auditLogger = auditLogger;
        this.authorizer = authorizer;
        this.bootErrorCollector = new BootErrorCollector();
        this.capabilityRegistry = capabilityRegistry.createShadowCopy();
    }

    @Override
    public void start(StartContext context) throws StartException {
        assert (this.capabilityRegistry.getPossibleCapabilities().isEmpty()) : "registry is not empty";
        if (this.configurationPersister == null) {
            throw ControllerLogger.ROOT_LOGGER.persisterNotInjected();
        }
        ServiceController<?> serviceController = context.getController();
        final ServiceContainer container = serviceController.getServiceContainer();
        final ServiceTarget target = context.getChildTarget();
        ExecutorService executorService = this.injectedExecutorService.getOptionalValue();
        NotificationSupport notificationSupport = NotificationSupport.Factory.create(executorService);
        WritableAuthorizerConfiguration authorizerConfig = this.authorizer.getWritableAuthorizerConfiguration();
        authorizerConfig.reset();
        ManagementResourceRegistration rootResourceRegistration = ManagementResourceRegistration.Factory.create(this.rootResourceDefinition, authorizerConfig, this.capabilityRegistry);
        ModelControllerImpl controller = new ModelControllerImpl(container, target, rootResourceRegistration, new ContainerStateMonitor(container), this.configurationPersister, this.processType, this.runningModeControl, this.prepareStep, this.processState, executorService, this.expressionResolver, this.authorizer, this.auditLogger, notificationSupport, this.bootErrorCollector, this.createExtraValidationStepHandler(), this.capabilityRegistry);
        this.initModel(controller.getManagementModel(), controller.getModelControllerResource());
        this.controller = controller;
        final long bootStackSize = AbstractControllerService.getBootStackSize();
        Thread bootThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        AbstractControllerService.this.boot(new BootContext(){

                            @Override
                            public ServiceTarget getServiceTarget() {
                                return target;
                            }
                        });
                    }
                    finally {
                        AbstractControllerService.this.processState.setRunning();
                    }
                }
                catch (Throwable t) {
                    container.shutdown();
                    if (t instanceof StackOverflowError) {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t, bootStackSize, AbstractControllerService.BOOT_STACK_SIZE_PROPERTY);
                    } else {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t);
                    }
                }
                finally {
                    AbstractControllerService.this.bootThreadDone();
                }
            }
        }, "Controller Boot Thread", bootStackSize);
        bootThread.start();
    }

    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        List<ModelNode> bootOps = this.configurationPersister.load();
        ModelNode op = this.registerModelControllerServiceInitializationBootStep(context);
        if (op != null) {
            bootOps.add(op);
        }
        this.boot(bootOps, false);
        this.finishBoot();
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        return this.boot(bootOperations, rollbackOnRuntimeFailure, false, ModelControllerImpl.getMutableRootResourceRegistrationProvider());
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure, boolean skipModelValidation) throws ConfigurationPersistenceException {
        return this.boot(bootOperations, rollbackOnRuntimeFailure, skipModelValidation, ModelControllerImpl.getMutableRootResourceRegistrationProvider());
    }

    @Deprecated
    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider) throws ConfigurationPersistenceException {
        return this.boot(bootOperations, rollbackOnRuntimeFailure, false, parallelBootRootResourceRegistrationProvider);
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure, boolean skipModelValidation, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider) throws ConfigurationPersistenceException {
        return this.controller.boot(bootOperations, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, rollbackOnRuntimeFailure, parallelBootRootResourceRegistrationProvider, skipModelValidation, skipModelValidation);
    }

    @Deprecated
    protected ModelNode internalExecute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep) {
        OperationResponse or = this.controller.internalExecute(operation, handler, control, attachments, prepareStep, false, false);
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf((Throwable)e, "Caught exception closing response to %s whose associated streams, if any, were not wanted", (Object)operation);
        }
        return result;
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, operation, prepareStep, false, false);
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, boolean attemptLock) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, operation, prepareStep, attemptLock, false);
    }

    protected OperationResponse internalExecute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, boolean attemptLock, boolean partialModel) {
        return this.controller.internalExecute(operation.getOperation(), handler, control, operation, prepareStep, attemptLock, partialModel);
    }

    @Deprecated
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep, int lockPermit) {
        return this.controller.executeReadOnlyOperation(operation, handler, control, prepareStep, lockPermit);
    }

    @Deprecated
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int lockPermit) {
        return this.controller.executeReadOnlyOperation(operation, handler, control, prepareStep, lockPermit);
    }

    @Deprecated
    protected ModelNode executeReadOnlyOperation(ModelNode operation, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.executeReadOnlyOperation(operation, control, prepareStep);
    }

    @Deprecated
    protected ModelNode executeReadOnlyOperation(ModelNode operation, Resource model, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        return this.controller.executeReadOnlyOperation(operation, model, control, prepareStep);
    }

    protected void finishBoot() throws ConfigurationPersistenceException {
        this.controller.finishBoot();
        this.configurationPersister.successfulBoot();
        this.capabilityRegistry.publish();
    }

    protected void bootThreadDone() {
    }

    protected final MutableRootResourceRegistrationProvider getMutableRootResourceRegistrationProvider() {
        return ModelControllerImpl.getMutableRootResourceRegistrationProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(final StopContext context) {
        this.capabilityRegistry.clear();
        this.capabilityRegistry.publish();
        this.controller = null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractControllerService.this.stopAsynchronous(context);
                }
                finally {
                    try {
                        AbstractControllerService.this.authorizer.shutdown();
                    }
                    finally {
                        context.complete();
                    }
                }
            }
        };
        ExecutorService executorService = this.injectedExecutorService.getOptionalValue();
        try {
            if (executorService != null) {
                try {
                    executorService.execute(r);
                }
                catch (RejectedExecutionException e) {
                    r.run();
                }
            } else {
                Thread executorShutdown = new Thread(r, this.getClass().getSimpleName() + " Shutdown Thread");
                executorShutdown.start();
            }
        }
        finally {
            context.asynchronous();
        }
    }

    protected void stopAsynchronous(StopContext context) {
    }

    @Override
    public ModelController getValue() throws IllegalStateException, IllegalArgumentException {
        ModelControllerImpl controller;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((controller = this.controller) == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.injectedExecutorService;
    }

    protected void setConfigurationPersister(ConfigurationPersister persister) {
        this.configurationPersister = persister;
    }

    protected abstract void initModel(ManagementModel var1, Resource var2);

    protected ManagedAuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    protected BootErrorCollector getBootErrorCollector() {
        return this.bootErrorCollector;
    }

    protected OperationStepHandler createExtraValidationStepHandler() {
        return null;
    }

    protected final ModelNode registerModelControllerServiceInitializationBootStep(BootContext context) {
        ModelControllerServiceInitializationParams initParams = this.getModelControllerServiceInitializationParams();
        if (initParams != null) {
            this.controller.getManagementModel().getRootResourceRegistration().registerOperationHandler(INIT_CONTROLLER_OP, new ModelControllerServiceInitializationBootStepHandler(initParams));
            return Util.createEmptyOperation(INIT_CONTROLLER_OP.getName(), PathAddress.EMPTY_ADDRESS);
        }
        return null;
    }

    protected ModelControllerServiceInitializationParams getModelControllerServiceInitializationParams() {
        return null;
    }

    protected static abstract class ModelControllerServiceInitializationParams {
        private final ServiceLoader<ModelControllerServiceInitialization> serviceLoader;

        public ModelControllerServiceInitializationParams(ServiceLoader<ModelControllerServiceInitialization> serviceLoader) {
            this.serviceLoader = serviceLoader;
        }

        protected abstract String getHostName();
    }

    private final class ModelControllerServiceInitializationBootStepHandler
    implements OperationStepHandler {
        private final ModelControllerServiceInitializationParams initParams;

        ModelControllerServiceInitializationBootStepHandler(ModelControllerServiceInitializationParams initParams) {
            this.initParams = initParams;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    assert (context instanceof OperationContextImpl);
                    ModelControllerImpl.ManagementModelImpl managementModel = ((OperationContextImpl)context).getManagementModel();
                    ServiceLoader sl = ModelControllerServiceInitializationBootStepHandler.this.initParams.serviceLoader;
                    String hostName = ModelControllerServiceInitializationBootStepHandler.this.initParams.getHostName();
                    assert (AbstractControllerService.this.processType != ProcessType.HOST_CONTROLLER || hostName != null);
                    for (ModelControllerServiceInitialization init : sl) {
                        if (AbstractControllerService.this.processType == ProcessType.HOST_CONTROLLER) {
                            init.initializeHost(context.getServiceTarget(), managementModel, hostName);
                            init.initializeDomain(context.getServiceTarget(), managementModel);
                            continue;
                        }
                        init.initializeStandalone(context.getServiceTarget(), managementModel);
                    }
                    managementModel.getRootResourceRegistration().unregisterOperationHandler(INIT_CONTROLLER_OP.getName());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

