/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.registry.AttributeAccess;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;

final class AttributeBinding {
    private final AttributeDefinition attribute;
    private final OperationStepHandler readOp;
    private final OperationStepHandler writeOp;
    private final AttributeAccess.AccessType accessType;

    AttributeBinding(AttributeDefinition attribute, OperationStepHandler readOp, OperationStepHandler writeOp, AttributeAccess.AccessType accessType) {
        this.attribute = attribute;
        this.readOp = readOp;
        this.writeOp = writeOp;
        this.accessType = accessType;
    }

    void register(ManagementResourceRegistration registration) {
        if (this.accessType == AttributeAccess.AccessType.READ_ONLY) {
            registration.registerReadOnlyAttribute(this.attribute, this.readOp);
        } else if (this.accessType == AttributeAccess.AccessType.READ_WRITE) {
            registration.registerReadWriteAttribute(this.attribute, this.readOp, this.writeOp);
        } else if (this.accessType == AttributeAccess.AccessType.METRIC) {
            registration.registerMetric(this.attribute, this.readOp);
        }
    }
}

