/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.shaded.jboss.as.controller.AbstractWriteAttributeHandler;
import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.ServiceVerificationHandler;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.msc.service.ServiceController;
import org.shaded.jboss.msc.service.ServiceName;

public abstract class RestartParentWriteAttributeHandler
extends AbstractWriteAttributeHandler<ModelNode> {
    private final String parentKeyName;

    public RestartParentWriteAttributeHandler(String parentKeyName, AttributeDefinition ... definitions) {
        super(definitions);
        this.parentKeyName = parentKeyName;
    }

    public RestartParentWriteAttributeHandler(String parentKeyName, Collection<AttributeDefinition> definitions) {
        super(definitions);
        this.parentKeyName = parentKeyName;
    }

    @Override
    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<ModelNode> handbackHolder) throws OperationFailedException {
        ModelNode parentModel;
        ServiceController<?> service;
        PathAddress address = this.getParentAddress(context.getCurrentAddress());
        ServiceName serviceName = this.getParentServiceName(address);
        ServiceController<?> serviceController = service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
        if (service == null) {
            return false;
        }
        boolean restartServices = this.isResourceServiceRestartAllowed(context, service);
        if (restartServices && (parentModel = this.getModel(context, address)) != null && context.markResourceRestarted(address, this)) {
            this.removeServices(context, serviceName, parentModel);
            this.recreateParentService(context, address, parentModel);
            handbackHolder.setHandback(parentModel);
        }
        return !restartServices;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return context.isResourceServiceRestartAllowed();
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        context.removeService(parentService);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
        this.recreateParentService(context, parentAddress, parentModel, ServiceVerificationHandler.INSTANCE);
    }

    @Deprecated
    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    protected abstract ServiceName getParentServiceName(PathAddress var1);

    protected PathAddress getParentAddress(PathAddress address) {
        return Util.getParentAddressByKey(address, this.parentKeyName);
    }

    @Override
    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode resolvedValue, ModelNode invalidatedParentModel) throws OperationFailedException {
        if (invalidatedParentModel == null) {
            return;
        }
        PathAddress address = this.getParentAddress(context.getCurrentAddress());
        ServiceName serviceName = this.getParentServiceName(address);
        ModelNode parentModel = this.getOriginalModel(context, address);
        if (parentModel != null && context.revertResourceRestarted(address, this)) {
            this.removeServices(context, serviceName, invalidatedParentModel);
            this.recreateParentService(context, address, parentModel);
        }
    }

    private ModelNode getModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.readResourceFromRoot(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private ModelNode getOriginalModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getOriginalRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

