/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.shaded.jboss.as.controller.AbstractAddStepHandler;
import org.shaded.jboss.as.controller.AbstractRemoveStepHandler;
import org.shaded.jboss.as.controller.DeprecationData;
import org.shaded.jboss.as.controller.ModelVersion;
import org.shaded.jboss.as.controller.OperationDefinition;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.as.controller.ResourceDefinition;
import org.shaded.jboss.as.controller.SimpleOperationDefinition;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.shaded.jboss.as.controller.capability.RuntimeCapability;
import org.shaded.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;
import org.shaded.jboss.as.controller.registry.OperationEntry;

public class SimpleResourceDefinition
implements ResourceDefinition {
    private static final EnumSet<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM);
    private final PathElement pathElement;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DescriptionProvider descriptionProvider;
    private final OperationStepHandler addHandler;
    private final OperationStepHandler removeHandler;
    private final OperationEntry.Flag addRestartLevel;
    private final OperationEntry.Flag removeRestartLevel;
    private final boolean runtime;
    private volatile DeprecationData deprecationData;
    private final boolean orderedChild;
    private final RuntimeCapability[] capabilities;

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, DescriptionProvider descriptionProvider) {
        if (descriptionProvider == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("descriptionProvider");
        }
        this.pathElement = pathElement;
        this.descriptionResolver = null;
        this.descriptionProvider = descriptionProvider;
        this.addHandler = null;
        this.removeHandler = null;
        this.addRestartLevel = null;
        this.removeRestartLevel = null;
        this.deprecationData = null;
        this.runtime = false;
        this.orderedChild = false;
        this.capabilities = new RuntimeCapability[0];
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
        this(pathElement, descriptionResolver, null, null, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, boolean isRuntime) {
        this(pathElement, descriptionResolver, null, null, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, null, isRuntime);
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, boolean isRuntime) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, null, isRuntime);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, DeprecationData deprecationData) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, deprecationData);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, addRestartLevel, removeRestartLevel, null);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel, DeprecationData deprecationData) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, addRestartLevel, removeRestartLevel, deprecationData, false);
    }

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel, DeprecationData deprecationData, boolean runtime) {
        if (descriptionResolver == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("descriptionProvider");
        }
        this.pathElement = pathElement;
        this.descriptionResolver = descriptionResolver;
        this.descriptionProvider = null;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
        this.addRestartLevel = addRestartLevel == null ? OperationEntry.Flag.RESTART_NONE : SimpleResourceDefinition.validateRestartLevel("addRestartLevel", addRestartLevel);
        this.removeRestartLevel = removeRestartLevel == null ? OperationEntry.Flag.RESTART_ALL_SERVICES : SimpleResourceDefinition.validateRestartLevel("removeRestartLevel", removeRestartLevel);
        this.deprecationData = deprecationData;
        this.runtime = runtime;
        this.orderedChild = false;
        this.capabilities = new RuntimeCapability[0];
    }

    public SimpleResourceDefinition(Parameters parameters) {
        this.pathElement = parameters.pathElement;
        this.descriptionResolver = parameters.descriptionResolver;
        this.addHandler = parameters.addHandler;
        this.removeHandler = parameters.removeHandler;
        this.addRestartLevel = parameters.addRestartLevel;
        this.removeRestartLevel = parameters.removeRestartLevel;
        this.deprecationData = parameters.deprecationData;
        this.runtime = parameters.runtime;
        this.orderedChild = parameters.orderedChildResource;
        this.descriptionProvider = null;
        this.capabilities = parameters.capabilities;
    }

    @Override
    public PathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return this.descriptionProvider == null ? new DefaultResourceDescriptionProvider(resourceRegistration, this.descriptionResolver, this.getDeprecationData()) : this.descriptionProvider;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        if (this.addHandler != null) {
            this.registerAddOperation(resourceRegistration, this.addHandler, this.addRestartLevel);
        }
        if (this.removeHandler != null) {
            this.registerRemoveOperation(resourceRegistration, this.removeHandler, this.removeRestartLevel);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerNotifications(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        if (this.capabilities != null) {
            for (RuntimeCapability c : this.capabilities) {
                resourceRegistration.registerCapability(c);
            }
        }
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return this.descriptionResolver;
    }

    @Deprecated
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler(this.getOperationDefinition("add", (DescriptionProvider)((Object)handler), OperationEntry.EntryType.PUBLIC, flags), handler);
        } else {
            registration.registerOperationHandler(this.getOperationDefinition("add", new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver, this.orderedChild), OperationEntry.EntryType.PUBLIC, flags), handler);
        }
    }

    private OperationDefinition getOperationDefinition(String operationName, DescriptionProvider descriptionProvider, OperationEntry.EntryType entryType, OperationEntry.Flag ... flags) {
        return new SimpleOperationDefinitionBuilder(operationName, this.descriptionResolver).withFlags(flags).setEntryType(entryType).setDescriptionProvider(descriptionProvider).build();
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, AbstractAddStepHandler handler, OperationEntry.Flag ... flags) {
        registration.registerOperationHandler(this.getOperationDefinition("add", new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver, this.orderedChild), OperationEntry.EntryType.PUBLIC, flags), handler);
    }

    @Deprecated
    protected void registerRemoveOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler(this.getOperationDefinition("remove", (DescriptionProvider)((Object)handler), OperationEntry.EntryType.PUBLIC, flags), handler);
        } else {
            SimpleOperationDefinition opDef = new SimpleOperationDefinitionBuilder("remove", this.descriptionResolver).withFlags(flags).build();
            registration.registerOperationHandler(opDef, handler);
        }
    }

    protected void registerRemoveOperation(ManagementResourceRegistration registration, AbstractRemoveStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerRemoveOperation(registration, (OperationStepHandler)handler, flags);
    }

    private static OperationEntry.Flag validateRestartLevel(String paramName, OperationEntry.Flag flag) {
        if (flag != null && !RESTART_FLAGS.contains((Object)flag)) {
            throw ControllerLogger.ROOT_LOGGER.invalidParameterValue(flag, paramName, RESTART_FLAGS);
        }
        return flag;
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        return SimpleOperationDefinitionBuilder.getFlagsSet(vararg);
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    protected void setDeprecated(ModelVersion since) {
        this.deprecationData = new DeprecationData(since);
    }

    protected DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    @Override
    public boolean isRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isOrderedChild() {
        return this.orderedChild;
    }

    public static class Parameters {
        private final PathElement pathElement;
        private ResourceDescriptionResolver descriptionResolver;
        private OperationStepHandler addHandler;
        private OperationStepHandler removeHandler;
        private OperationEntry.Flag addRestartLevel = OperationEntry.Flag.RESTART_NONE;
        private OperationEntry.Flag removeRestartLevel = OperationEntry.Flag.RESTART_ALL_SERVICES;
        private boolean runtime;
        private DeprecationData deprecationData;
        private boolean orderedChildResource;
        private RuntimeCapability[] capabilities;

        public Parameters(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
            if (descriptionResolver == null) {
                throw ControllerLogger.ROOT_LOGGER.nullVar("descriptionResolver");
            }
            this.pathElement = pathElement;
            this.descriptionResolver = descriptionResolver;
        }

        public Parameters setDescriptionResolver(ResourceDescriptionResolver descriptionResolver) {
            this.descriptionResolver = descriptionResolver;
            return this;
        }

        public Parameters setAddHandler(OperationStepHandler addHandler) {
            this.addHandler = addHandler;
            return this;
        }

        public Parameters setRemoveHandler(OperationStepHandler removeHandler) {
            this.removeHandler = removeHandler;
            return this;
        }

        public Parameters setAddRestartLevel(OperationEntry.Flag addRestartLevel) {
            if (addRestartLevel == null) {
                throw ControllerLogger.ROOT_LOGGER.nullVar("addRestartLevel");
            }
            this.addRestartLevel = addRestartLevel;
            return this;
        }

        public Parameters setRemoveRestartLevel(OperationEntry.Flag removeRestartLevel) {
            if (removeRestartLevel == null) {
                throw ControllerLogger.ROOT_LOGGER.nullVar("addRestartLevel");
            }
            this.removeRestartLevel = removeRestartLevel;
            return this;
        }

        public Parameters setRuntime() {
            this.runtime = true;
            return this;
        }

        public Parameters setRuntime(boolean isRuntime) {
            this.runtime = isRuntime;
            return this;
        }

        public Parameters setDeprecationData(DeprecationData deprecationData) {
            this.deprecationData = deprecationData;
            return this;
        }

        public Parameters setDeprecatedSince(ModelVersion deprecatedSince) {
            if (deprecatedSince == null) {
                throw ControllerLogger.ROOT_LOGGER.nullVar("deprecatedSince");
            }
            this.deprecationData = new DeprecationData(deprecatedSince);
            return this;
        }

        public Parameters setOrderedChild() {
            this.orderedChildResource = true;
            return this;
        }

        public Parameters setCapabilities(RuntimeCapability ... capabilities) {
            this.capabilities = capabilities;
            return this;
        }
    }
}

