/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.shaded.jboss.as.controller.access.Action;

public class JmxAction {
    private static final Set<Action.ActionEffect> WRITES = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_RUNTIME));
    private static final Set<Action.ActionEffect> READS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_RUNTIME));
    private final String methodName;
    private final String attribute;
    private final Impact impact;

    public JmxAction(String methodName, Impact impact) {
        this(methodName, impact, null);
    }

    public JmxAction(String methodName, Impact impact, String attribute) {
        this.methodName = methodName;
        this.impact = impact;
        this.attribute = attribute;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getAttributeName() {
        return this.attribute;
    }

    public Set<Action.ActionEffect> getActionEffects() {
        switch (this.getImpact()) {
            case CLASSLOADING: 
            case WRITE: {
                return WRITES;
            }
            case READ_ONLY: {
                return READS;
            }
        }
        throw new IllegalStateException();
    }

    public static enum Impact {
        READ_ONLY,
        WRITE,
        CLASSLOADING;

    }
}

