/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.constraint;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.shaded.jboss.as.controller.access.Action;
import org.shaded.jboss.as.controller.access.HostEffect;
import org.shaded.jboss.as.controller.access.JmxAction;
import org.shaded.jboss.as.controller.access.JmxTarget;
import org.shaded.jboss.as.controller.access.TargetAttribute;
import org.shaded.jboss.as.controller.access.TargetResource;
import org.shaded.jboss.as.controller.access.constraint.AbstractConstraint;
import org.shaded.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.shaded.jboss.as.controller.access.constraint.Constraint;
import org.shaded.jboss.as.controller.access.constraint.ScopingConstraint;
import org.shaded.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import org.shaded.jboss.as.controller.access.rbac.StandardRole;
import org.shaded.jboss.as.controller.logging.ControllerLogger;

public class HostEffectConstraint
extends AbstractConstraint
implements Constraint,
ScopingConstraint {
    public static final ScopingConstraintFactory FACTORY = new Factory();
    private static final HostEffectConstraint GLOBAL_USER = new HostEffectConstraint(true);
    private static final HostEffectConstraint GLOBAL_REQUIRED = new HostEffectConstraint(false);
    private final boolean user;
    private final boolean global;
    private final HostsHolder hostsHolder;
    private final boolean readOnly;
    private final HostEffectConstraint readOnlyConstraint;

    private HostEffectConstraint(boolean user) {
        this.user = user;
        this.global = true;
        this.readOnly = false;
        this.readOnlyConstraint = null;
        this.hostsHolder = new HostsHolder();
    }

    private HostEffectConstraint(Set<String> allowed) {
        this.user = false;
        this.global = false;
        this.hostsHolder = new HostsHolder(allowed);
        this.readOnly = false;
        this.readOnlyConstraint = null;
    }

    public HostEffectConstraint(List<String> allowed) {
        this.user = true;
        this.global = false;
        this.hostsHolder = new HostsHolder(allowed);
        this.readOnly = false;
        this.readOnlyConstraint = new HostEffectConstraint(this.hostsHolder, true);
    }

    private HostEffectConstraint(HostsHolder hostsHolder, boolean readOnly) {
        this.user = true;
        this.global = false;
        this.hostsHolder = hostsHolder;
        this.readOnly = readOnly;
        this.readOnlyConstraint = null;
    }

    public void setAllowedHosts(List<String> allowed) {
        assert (!this.global) : "constraint is global";
        assert (this.readOnlyConstraint != null) : "invalid cast";
        this.hostsHolder.specific = new LinkedHashSet<String>(allowed);
    }

    @Override
    public boolean violates(Constraint other, Action.ActionEffect actionEffect) {
        if (other instanceof HostEffectConstraint) {
            HostEffectConstraint hec = (HostEffectConstraint)other;
            Set ourSpecific = this.hostsHolder.specific;
            Set hecSpecific = hec.hostsHolder.specific;
            if (this.user) {
                assert (!hec.user) : "illegal comparison";
                if (this.readOnly) {
                    if (!hec.global) {
                        boolean anyMatch = this.anyMatch(ourSpecific, hecSpecific);
                        if (!anyMatch) {
                            ControllerLogger.ACCESS_LOGGER.tracef("read-only host constraint violated for action %s due to no match between hosts %s and allowed hosts %s", (Object)actionEffect, (Object)hecSpecific, (Object)ourSpecific);
                        }
                        return !anyMatch;
                    }
                } else if (!this.global) {
                    if (hec.global) {
                        ControllerLogger.ACCESS_LOGGER.tracef("host constraint violated for action %s due to requirement for access to global resources", (Object)actionEffect);
                        return true;
                    }
                    if (actionEffect == Action.ActionEffect.WRITE_RUNTIME || actionEffect == Action.ActionEffect.WRITE_CONFIG) {
                        boolean containsAll = ourSpecific.containsAll(hecSpecific);
                        if (!containsAll) {
                            ControllerLogger.ACCESS_LOGGER.tracef("host constraint violated for action %s due to mismatch of hosts %s vs hosts %s", (Object)actionEffect, (Object)hecSpecific, (Object)ourSpecific);
                        }
                        return !containsAll;
                    }
                    boolean anyMatch = this.anyMatch(ourSpecific, hecSpecific);
                    if (!anyMatch) {
                        ControllerLogger.ACCESS_LOGGER.tracef("host constraint violated for action %s due to no match between hosts %s and allowed hosts %s", (Object)actionEffect, (Object)hecSpecific, (Object)ourSpecific);
                    }
                    return !anyMatch;
                }
            } else {
                assert (hec.user) : "illegal comparison";
                return other.violates(this, actionEffect);
            }
        }
        return false;
    }

    private boolean anyMatch(Set<String> ourSpecific, Set<String> hecSpecific) {
        boolean matched = false;
        for (String ourGroup : ourSpecific) {
            if (!hecSpecific.contains(ourGroup)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            matched = hecSpecific.size() == 1 && hecSpecific.contains("*");
        }
        return matched;
    }

    @Override
    public boolean replaces(Constraint other) {
        return other instanceof HostEffectConstraint && (this.readOnly || this.readOnlyConstraint != null);
    }

    @Override
    public ScopingConstraintFactory getFactory() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return FACTORY;
    }

    @Override
    public Constraint getStandardConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this;
    }

    @Override
    public Constraint getOutofScopeReadConstraint() {
        assert (this.readOnlyConstraint != null) : "invalid cast";
        return this.readOnlyConstraint;
    }

    private static class Factory
    extends AbstractConstraintFactory
    implements ScopingConstraintFactory {
        private Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            return GLOBAL_USER;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(target.getHostEffect());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.getRequiredConstraint(target.getHostEffect());
        }

        private Constraint getRequiredConstraint(HostEffect hostEffect) {
            if (hostEffect == null || hostEffect.isHostEffectGlobal()) {
                return GLOBAL_REQUIRED;
            }
            return new HostEffectConstraint(hostEffect.getAffectedHosts());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return this.getRequiredConstraint(target.getHostEffect());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return this.equals(other) ? 0 : -1;
        }
    }

    private static class HostsHolder {
        private volatile Set<String> specific = new LinkedHashSet<String>();

        private HostsHolder() {
        }

        private HostsHolder(Collection<String> hosts) {
            this.specific.addAll(hosts);
        }
    }
}

