/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import org.shaded.jboss.as.controller.ControlledProcessState;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.access.Action;
import org.shaded.jboss.as.controller.access.AuthorizationResult;
import org.shaded.jboss.as.controller.access.Authorizer;
import org.shaded.jboss.as.controller.access.Caller;
import org.shaded.jboss.as.controller.access.Environment;
import org.shaded.jboss.as.controller.access.JmxAction;
import org.shaded.jboss.as.controller.access.JmxTarget;
import org.shaded.jboss.as.controller.access.TargetAttribute;
import org.shaded.jboss.as.controller.access.TargetResource;
import org.shaded.jboss.as.controller.access.permission.AllPermissionsCollection;
import org.shaded.jboss.as.controller.access.permission.PermissionFactory;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.dmr.ModelNode;

public class ManagementPermissionAuthorizer
implements Authorizer {
    private final PermissionFactory permissionFactory;

    public ManagementPermissionAuthorizer(PermissionFactory permissionFactory) {
        this.permissionFactory = permissionFactory;
    }

    @Override
    public Authorizer.AuthorizerDescription getDescription() {
        return new Authorizer.AuthorizerDescription(){

            @Override
            public boolean isRoleBased() {
                return true;
            }

            @Override
            public Set<String> getStandardRoles() {
                return Collections.emptySet();
            }
        };
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
        assert (ManagementPermissionAuthorizer.assertSameAddress(action, target.getTargetResource()));
        if (this.isServerBooting(callEnvironment)) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    @Override
    public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
        assert (ManagementPermissionAuthorizer.assertSameAddress(action, target));
        if (this.isServerBooting(callEnvironment)) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        if (userPerms == AllPermissionsCollection.INSTANCE) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    private static boolean assertSameAddress(Action action, TargetResource target) {
        ModelNode operation = action.getOperation();
        return operation == null || target.getResourceAddress().equals(PathAddress.pathAddress(operation.get("address")));
    }

    private AuthorizationResult authorize(PermissionCollection userPermissions, PermissionCollection requiredPermissions) {
        Enumeration<Permission> enumeration = requiredPermissions.elements();
        while (enumeration.hasMoreElements()) {
            Permission requiredPermission = enumeration.nextElement();
            if (userPermissions.implies(requiredPermission)) continue;
            return new AuthorizationResult(AuthorizationResult.Decision.DENY, new ModelNode(ControllerLogger.ROOT_LOGGER.permissionDenied()));
        }
        return AuthorizationResult.PERMITTED;
    }

    @Override
    public AuthorizationResult authorizeJmxOperation(Caller caller, Environment callEnvironment, JmxAction action, JmxTarget target) {
        if (this.isServerBooting(callEnvironment)) {
            return AuthorizationResult.PERMITTED;
        }
        PermissionCollection userPerms = this.permissionFactory.getUserPermissions(caller, callEnvironment, action, target);
        PermissionCollection requiredPerms = this.permissionFactory.getRequiredPermissions(action, target);
        return this.authorize(userPerms, requiredPerms);
    }

    @Override
    public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsRoles) {
        return null;
    }

    private boolean isServerBooting(Environment callEnvironment) {
        return callEnvironment != null && callEnvironment.getProcessState() == ControlledProcessState.State.STARTING;
    }
}

