/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.permission;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.shaded.jboss.as.controller.access.Action;
import org.shaded.jboss.as.controller.access.permission.ManagementPermission;
import org.shaded.jboss.as.controller.logging.ControllerLogger;

public class ManagementPermissionCollection
extends PermissionCollection {
    private final Class<? extends ManagementPermission> type;
    private final String name;
    private final Map<Action.ActionEffect, ManagementPermission> permissions = new HashMap<Action.ActionEffect, ManagementPermission>();

    public ManagementPermissionCollection(Class<? extends ManagementPermission> type) {
        this(null, type);
    }

    public ManagementPermissionCollection(String name, Class<? extends ManagementPermission> type) {
        this.name = name;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw ControllerLogger.ROOT_LOGGER.permissionCollectionIsReadOnly();
        }
        if (this.type.equals(permission.getClass())) {
            ManagementPermission mperm = (ManagementPermission)permission;
            Map<Action.ActionEffect, ManagementPermission> map = this.permissions;
            synchronized (map) {
                this.permissions.put(mperm.getActionEffect(), mperm);
            }
        } else {
            throw ControllerLogger.ROOT_LOGGER.incompatiblePermissionType(permission.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof ManagementPermission) {
            ManagementPermission provided;
            ManagementPermission mperm = (ManagementPermission)permission;
            Action.ActionEffect actionEffect = mperm.getActionEffect();
            Map<Action.ActionEffect, ManagementPermission> map = this.permissions;
            synchronized (map) {
                provided = this.permissions.get((Object)actionEffect);
            }
            if (provided == null) {
                ControllerLogger.ACCESS_LOGGER.tracef("Permission collection '%s' does not provide a permission for %s", (Object)this.name, (Object)actionEffect);
                return false;
            }
            if (!provided.implies(mperm)) {
                ControllerLogger.ACCESS_LOGGER.tracef("Permission provided in collection '%s' for action %s does not imply the requested permission", (Object)this.name, (Object)actionEffect);
                return false;
            }
            return true;
        }
        ControllerLogger.ACCESS_LOGGER.tracef("Permission collection %s does not imply %s as it is not a ManagementPermission", (Object)this.name, (Object)permission);
        return false;
    }

    @Override
    public Enumeration<Permission> elements() {
        final Iterator<ManagementPermission> iterator = this.iterator();
        return new Enumeration<Permission>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public Permission nextElement() {
                return (Permission)iterator.next();
            }
        };
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<ManagementPermission> iterator() {
        Map<Action.ActionEffect, ManagementPermission> map = this.permissions;
        synchronized (map) {
            return this.permissions.values().iterator();
        }
    }
}

