/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.capability.registry;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.shaded.jboss.as.controller.registry.Resource;

public abstract class CapabilityResolutionContext {
    private final ConcurrentMap<AttachmentKey<?>, Object> contextAttachments = new ConcurrentHashMap();

    public abstract Resource getResourceRoot();

    public <V> V getAttachment(AttachmentKey<V> key) {
        assert (key != null);
        return key.cast(this.contextAttachments.get(key));
    }

    public <V> V attach(AttachmentKey<V> key, V value) {
        assert (key != null);
        return key.cast(this.contextAttachments.put(key, value));
    }

    public <V> V attachIfAbsent(AttachmentKey<V> key, V value) {
        assert (key != null);
        return key.cast(this.contextAttachments.putIfAbsent(key, value));
    }

    public <V> V detach(AttachmentKey<V> key) {
        assert (key != null);
        return key.cast(this.contextAttachments.remove(key));
    }

    protected void reset() {
        this.contextAttachments.clear();
    }

    public static final class AttachmentKey<T> {
        private final Class<T> valueClass;

        private AttachmentKey(Class<T> valueClass) {
            this.valueClass = valueClass;
        }

        public T cast(Object value) {
            return this.valueClass.cast(value);
        }

        public static <T> AttachmentKey<T> create(Class<? super T> valueClass) {
            return new AttachmentKey<T>(valueClass);
        }
    }
}

