/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers;

import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;

public enum MeasurementUnit {
    NONE("", Family.ABSOLUTE, Scale.ONE),
    PERCENTAGE("%", Family.RELATIVE, Scale.HECTO),
    BYTES("B", Family.BYTES, Scale.ONE),
    KILOBYTES("KB", Family.BYTES, Scale.KILO),
    MEGABYTES("MB", Family.BYTES, Scale.MEGA),
    GIGABYTES("GB", Family.BYTES, Scale.GIGA),
    TERABYTES("TB", Family.BYTES, Scale.TERA),
    PETABYTES("PB", Family.BYTES, Scale.PETA),
    BITS("b", Family.BITS, Scale.ONE),
    KILOBITS("Kb", Family.BITS, Scale.KILO),
    MEGABITS("Mb", Family.BITS, Scale.MEGA),
    GIGABITS("Gb", Family.BITS, Scale.GIGA),
    TERABITS("Tb", Family.BITS, Scale.TERA),
    PETABITS("Pb", Family.BITS, Scale.PETA),
    EPOCH_MILLISECONDS("", Family.DURATION, Scale.MILLI),
    EPOCH_SECONDS("", Family.DURATION, Scale.SEC),
    JIFFYS("j", Family.TIME, Scale.JIFFY),
    NANOSECONDS("ns", Family.TIME, Scale.NANO),
    MICROSECONDS("us", Family.TIME, Scale.MICRO),
    MILLISECONDS("ms", Family.TIME, Scale.MILLI),
    SECONDS("s", Family.TIME, Scale.SEC),
    MINUTES("m", Family.TIME, Scale.MIN),
    HOURS("h", Family.TIME, Scale.HOUR),
    DAYS("d", Family.TIME, Scale.DAY),
    PER_JIFFY("/j", Family.RATE, Scale.PER_JIFFY),
    PER_NANOSECOND("/ns", Family.RATE, Scale.PER_NANO),
    PER_MICROSECOND("/us", Family.RATE, Scale.PER_MICRO),
    PER_MILLISECOND("/ms", Family.RATE, Scale.PER_MILLI),
    PER_SECOND("/s", Family.RATE, Scale.PER_SEC),
    PER_MINUTE("/m", Family.RATE, Scale.PER_MIN),
    PER_HOUR("/h", Family.RATE, Scale.PER_HOUR),
    PER_DAY(" /d", Family.RATE, Scale.PER_DAY),
    CELSIUS("C", Family.TEMPERATURE, Scale.ONE),
    KELVIN("K", Family.TEMPERATURE, Scale.ONE),
    FAHRENHEIGHT("F", Family.TEMPERATURE, Scale.ONE);

    private String displayUnits;
    private Family family;
    private Scale scale;

    private MeasurementUnit(String displayUnits, Family family, Scale scale) {
        if (displayUnits.length() > 5) {
            throw ControllerClientLogger.ROOT_LOGGER.maxDisplayUnitLength();
        }
        this.displayUnits = displayUnits;
        this.family = family;
        this.scale = scale;
    }

    public static MeasurementUnit getUsingDisplayUnits(String displayUnits, Family family) {
        for (MeasurementUnit units : MeasurementUnit.values()) {
            if (units.getFamily() != family || !units.toString().equalsIgnoreCase(displayUnits)) continue;
            return units;
        }
        return null;
    }

    public MeasurementUnit getBaseUnits() {
        if (this.family == Family.BYTES) {
            return BYTES;
        }
        if (this.family == Family.BITS) {
            return BITS;
        }
        if (this.family == Family.TIME) {
            return SECONDS;
        }
        if (this.family == Family.RATE) {
            return PER_SECOND;
        }
        if (this.family == Family.TEMPERATURE) {
            return CELSIUS;
        }
        if (this.family == Family.ABSOLUTE || this.family == Family.DURATION || this.family == Family.RELATIVE) {
            return this;
        }
        return null;
    }

    public boolean isComparableTo(MeasurementUnit other) {
        return this.family == other.family;
    }

    public static Double calculateOffset(MeasurementUnit first, MeasurementUnit second) throws MeasurementConversionException {
        if (!first.isComparableTo(second)) {
            throw new MeasurementConversionException(ControllerClientLogger.ROOT_LOGGER.cannotConvert(first.name(), second.name()));
        }
        return Scale.calculateOffset(first.scale, second.scale);
    }

    public Family getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.displayUnits;
    }

    public static class MeasurementConversionException
    extends RuntimeException {
        public MeasurementConversionException(String message) {
            super(message);
        }
    }

    private static enum Scale {
        CENTI(Type.SIZE),
        ONE(Type.SIZE, CENTI, 100.0),
        HECTO(Type.SIZE, ONE, 100.0),
        KILO(Type.SIZE, ONE, 1024.0),
        MEGA(Type.SIZE, KILO, 1024.0),
        GIGA(Type.SIZE, MEGA, 1024.0),
        TERA(Type.SIZE, GIGA, 1024.0),
        PETA(Type.SIZE, TERA, 1024.0),
        JIFFY(Type.TIME),
        NANO(Type.TIME, JIFFY, 1000.0),
        MICRO(Type.TIME, NANO, 1000.0),
        MILLI(Type.TIME, MICRO, 1000.0),
        SEC(Type.TIME, MILLI, 1000.0),
        MIN(Type.TIME, SEC, 60.0),
        HOUR(Type.TIME, MIN, 60.0),
        DAY(Type.TIME, HOUR, 24.0),
        WEEK(Type.TIME, DAY, 7.0),
        YEAR(Type.TIME, WEEK, 52.0),
        PER_JIFFY(Type.RATE),
        PER_NANO(Type.RATE, PER_JIFFY, 0.001),
        PER_MICRO(Type.RATE, PER_NANO, 0.001),
        PER_MILLI(Type.RATE, PER_MICRO, 0.001),
        PER_SEC(Type.RATE, PER_MILLI, 0.001),
        PER_MIN(Type.RATE, PER_SEC, 0.016666666666666666),
        PER_HOUR(Type.RATE, PER_MIN, 0.016666666666666666),
        PER_DAY(Type.RATE, PER_HOUR, 0.041666666666666664),
        PER_WEEK(Type.RATE, PER_DAY, 0.14285714285714285),
        PER_YEAR(Type.RATE, PER_WEEK, 0.019230769230769232);

        private Type type;
        private Scale comparisonScale;
        private double offset;

        private Scale(Type type) {
            this.type = type;
        }

        private Scale(Type type, Scale comparisonScale, double offset) {
            this(type);
            this.comparisonScale = comparisonScale;
            this.offset = offset;
        }

        static Double scaleUp(Double value, Scale scale) {
            if (null == scale) {
                return 0.0;
            }
            return value * scale.offset;
        }

        static Double scaleDown(Double value, Scale scale) {
            if (null == scale) {
                return 0.0;
            }
            return value / scale.offset;
        }

        static Double calculateOffset(Scale first, Scale second) {
            Scale lower;
            Scale higher;
            if (first.type != second.type) {
                return null;
            }
            if (first.comparisonScale == null && second.comparisonScale == null) {
                return 1.0;
            }
            if (first.comparisonScale == null) {
                higher = second;
                lower = first;
            } else if (second.comparisonScale == null) {
                higher = first;
                lower = second;
            } else if (first.comparisonScale.ordinal() > second.comparisonScale.ordinal()) {
                higher = first;
                lower = second;
            } else if (first.comparisonScale.ordinal() < second.comparisonScale.ordinal()) {
                higher = second;
                lower = first;
            } else {
                return 1.0;
            }
            double results = 1.0;
            Scale movingScale = higher;
            while (movingScale != lower && movingScale.comparisonScale != null) {
                results *= movingScale.offset;
                movingScale = movingScale.comparisonScale;
            }
            if (first == lower) {
                return 1.0 / results;
            }
            return results;
        }

        static enum Type {
            NONE,
            SIZE,
            TIME,
            RATE;

        }
    }

    public static enum Family {
        ABSOLUTE,
        BITS,
        BYTES,
        DURATION,
        RELATIVE,
        RATE,
        TIME,
        TEMPERATURE;

    }
}

