/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.shaded.jboss.as.controller.client.helpers.domain.UpdateFailedException;

public class BasicDomainUpdateResult
implements Serializable {
    private static final long serialVersionUID = -3525117172870002485L;
    private final UpdateFailedException domainFailure;
    private final Map<String, UpdateFailedException> hostFailures = new HashMap<String, UpdateFailedException>();
    private final boolean cancelled;
    private final boolean rolledBack;

    public BasicDomainUpdateResult(boolean cancelled) {
        this.cancelled = cancelled;
        this.rolledBack = !cancelled;
        this.domainFailure = null;
    }

    public BasicDomainUpdateResult(UpdateFailedException domainFailure, boolean rolledBack) {
        this.domainFailure = domainFailure;
        this.cancelled = false;
        this.rolledBack = rolledBack;
    }

    public BasicDomainUpdateResult(Map<String, UpdateFailedException> hostFailures, boolean rolledBack) {
        this.domainFailure = null;
        if (hostFailures != null) {
            this.hostFailures.putAll(hostFailures);
        }
        this.cancelled = false;
        this.rolledBack = rolledBack;
    }

    public BasicDomainUpdateResult() {
        this.domainFailure = null;
        this.cancelled = false;
        this.rolledBack = false;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isRolledBack() {
        return this.rolledBack;
    }

    public UpdateFailedException getDomainFailure() {
        return this.domainFailure;
    }

    public Map<String, UpdateFailedException> getHostFailures() {
        return Collections.unmodifiableMap(this.hostFailures);
    }
}

