/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import java.io.Serializable;
import java.util.UUID;
import org.shaded.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;

public class DeploymentActionImpl
implements DeploymentAction,
Serializable {
    private static final long serialVersionUID = 613098200977026475L;
    private final UUID uuid = UUID.randomUUID();
    private final DeploymentAction.Type type;
    private final String deploymentUnitName;
    private final String oldDeploymentUnitName;
    private final String newContentFileName;
    private final byte[] newContentHash;

    public static DeploymentActionImpl getAddAction(String deploymentName, String fileName, byte[] hash) {
        assert (fileName != null) : "fileName is null";
        assert (hash != null) : "hash is null";
        return new DeploymentActionImpl(DeploymentAction.Type.ADD, deploymentName, fileName, hash, null);
    }

    public static DeploymentActionImpl getDeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.DEPLOY, deploymentName, null, null, null);
    }

    public static DeploymentActionImpl getRedeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REDEPLOY, deploymentName, null, null, null);
    }

    public static DeploymentActionImpl getUndeployAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.UNDEPLOY, deploymentName, null, null, null);
    }

    public static DeploymentActionImpl getReplaceAction(String deploymentName, String replacedName) {
        if (replacedName == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("replacedName");
        }
        return new DeploymentActionImpl(DeploymentAction.Type.REPLACE, deploymentName, null, null, replacedName);
    }

    public static DeploymentActionImpl getFullReplaceAction(String deploymentName, String fileName, byte[] hash) {
        assert (fileName != null) : "fileName is null";
        assert (hash != null) : "hash is null";
        return new DeploymentActionImpl(DeploymentAction.Type.FULL_REPLACE, deploymentName, fileName, hash, null);
    }

    public static DeploymentActionImpl getRemoveAction(String deploymentName) {
        return new DeploymentActionImpl(DeploymentAction.Type.REMOVE, deploymentName, null, null, null);
    }

    private DeploymentActionImpl(DeploymentAction.Type type, String deploymentUnitName, String newContentFileName, byte[] newContentHash, String replacedDeploymentUnitName) {
        if (type == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("type");
        }
        if (deploymentUnitName == null) {
            throw ControllerClientLogger.ROOT_LOGGER.nullVar("deploymentUnitName");
        }
        this.type = type;
        this.deploymentUnitName = deploymentUnitName;
        this.newContentFileName = newContentFileName;
        this.newContentHash = newContentHash;
        this.oldDeploymentUnitName = replacedDeploymentUnitName;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public DeploymentAction.Type getType() {
        return this.type;
    }

    @Override
    public String getDeploymentUnitUniqueName() {
        return this.deploymentUnitName;
    }

    @Override
    public String getReplacedDeploymentUnitUniqueName() {
        return this.oldDeploymentUnitName;
    }

    public String getNewContentFileName() {
        return this.newContentFileName;
    }

    public byte[] getNewContentHash() {
        return this.newContentHash;
    }
}

